/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.IPropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;

public class DataSourcePropertyFilter
implements IPropertyFilter {
    private final boolean showExpensive;

    public DataSourcePropertyFilter() {
        this((DBPDataSourceContainer)null);
    }

    public DataSourcePropertyFilter(DBPDataSource dataSource) {
        this(dataSource == null ? null : dataSource.getContainer());
    }

    public DataSourcePropertyFilter(DBPDataSourceContainer container) {
        DBPPreferenceStore store = container != null ? container.getPreferenceStore() : DBeaverCore.getGlobalPreferenceStore();
        this.showExpensive = store.getBoolean("database.props.expensive");
    }

    @Override
    public boolean select(DBPPropertyDescriptor toTest) {
        if (toTest instanceof ObjectPropertyDescriptor) {
            ObjectPropertyDescriptor prop = (ObjectPropertyDescriptor)toTest;
            return !prop.isExpensive() || this.showExpensive;
        }
        return false;
    }
}

