/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.updater;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.registry.updater.DistributionDescriptor;
import org.jkiss.dbeaver.registry.updater.UpdateSiteDescriptor;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

public class VersionDescriptor {
    private String programName;
    private Version programVersion;
    private String updateTime;
    private String baseURL;
    private String releaseNotes;
    private final List<DistributionDescriptor> distributions = new ArrayList<DistributionDescriptor>();
    private final List<UpdateSiteDescriptor> updateSites = new ArrayList<UpdateSiteDescriptor>();

    public VersionDescriptor(String fileAddr) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = WebUtils.openConnection(fileAddr).getInputStream();){
                this.parseVersionInfo(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLException e) {
            throw new IOException("XML parse error", e);
        }
    }

    public String getProgramName() {
        return this.programName;
    }

    public Version getProgramVersion() {
        return this.programVersion;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public Collection<DistributionDescriptor> getDistributions() {
        return this.distributions;
    }

    public Collection<UpdateSiteDescriptor> getUpdateSites() {
        return this.updateSites;
    }

    private void parseVersionInfo(InputStream inputStream) throws IOException, XMLException {
        SAXReader parser = new SAXReader(inputStream);
        SAXListener dsp = new SAXListener(){
            private String lastTag;
            private StringBuilder textBuffer = new StringBuilder();

            public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
                this.lastTag = localName;
                this.textBuffer.setLength(0);
            }

            public void saxText(SAXReader reader, String data) throws XMLException {
                this.textBuffer.append(data);
            }

            public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
                String text = this.textBuffer.toString();
                switch (this.lastTag) {
                    case "name": {
                        VersionDescriptor.this.programName = text;
                        break;
                    }
                    case "number": {
                        VersionDescriptor.this.programVersion = Version.parseVersion((String)text);
                        break;
                    }
                    case "date": {
                        VersionDescriptor.this.updateTime = text;
                        break;
                    }
                    case "base-url": {
                        VersionDescriptor.this.baseURL = text;
                        break;
                    }
                    case "release-notes": {
                        VersionDescriptor.this.releaseNotes = text;
                    }
                }
                this.textBuffer.setLength(0);
            }
        };
        parser.parse(dsp);
    }
}

