/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.editor.EntityEditorDescriptor;
import org.jkiss.dbeaver.registry.editor.EntityManagerDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.utils.CommonUtils;

public class EntityEditorsRegistry
implements DBERegistry {
    private static final String TAG_EDITOR = "editor";
    private static final String TAG_MANAGER = "manager";
    private static EntityEditorsRegistry instance = null;
    private EntityEditorDescriptor defaultEditor;
    private List<EntityEditorDescriptor> entityEditors = new ArrayList<EntityEditorDescriptor>();
    private Map<String, List<EntityEditorDescriptor>> positionsMap = new HashMap<String, List<EntityEditorDescriptor>>();
    private List<EntityManagerDescriptor> entityManagers = new ArrayList<EntityManagerDescriptor>();
    private Map<String, EntityManagerDescriptor> entityManagerMap = new HashMap<String, EntityManagerDescriptor>();

    public static synchronized EntityEditorsRegistry getInstance() {
        if (instance == null) {
            instance = new EntityEditorsRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public EntityEditorsRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        this.defaultEditor = new EntityEditorDescriptor();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.databaseEditor");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDescriptor descriptor;
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_EDITOR.equals(ext.getName())) {
                descriptor = new EntityEditorDescriptor(ext);
                this.entityEditors.add((EntityEditorDescriptor)descriptor);
                List<EntityEditorDescriptor> list = this.positionsMap.get(descriptor.getPosition());
                if (list == null) {
                    list = new ArrayList<EntityEditorDescriptor>();
                    this.positionsMap.put(descriptor.getPosition(), list);
                }
                list.add((EntityEditorDescriptor)descriptor);
            } else if (TAG_MANAGER.equals(ext.getName())) {
                descriptor = new EntityManagerDescriptor(ext);
                this.entityManagers.add((EntityManagerDescriptor)descriptor);
            }
            ++n2;
        }
        for (EntityManagerDescriptor em : this.entityManagers) {
            this.entityManagerMap.put(em.getObjectType().getImplName(), em);
        }
    }

    public void dispose() {
        this.entityEditors.clear();
        for (EntityManagerDescriptor descriptor : this.entityManagers) {
            descriptor.dispose();
        }
        this.entityManagers.clear();
        this.entityManagerMap.clear();
    }

    public EntityEditorDescriptor getMainEntityEditor(DBPObject object, IEntityEditorContext context) {
        for (EntityEditorDescriptor descriptor : this.entityEditors) {
            if (!descriptor.appliesTo(object, context) || !descriptor.isMain() || descriptor.getType() != EntityEditorDescriptor.Type.editor) continue;
            return descriptor;
        }
        return this.defaultEditor;
    }

    public List<EntityEditorDescriptor> getEntityEditors(DBPObject object, IEntityEditorContext context, String position) {
        List<EntityEditorDescriptor> positionList;
        ArrayList<EntityEditorDescriptor> editors = new ArrayList<EntityEditorDescriptor>();
        List<EntityEditorDescriptor> list = positionList = CommonUtils.isEmpty((String)position) ? this.entityEditors : this.positionsMap.get(position);
        if (positionList != null) {
            for (EntityEditorDescriptor descriptor : positionList) {
                if (!descriptor.appliesTo(object, context)) continue;
                editors.add(descriptor);
            }
        }
        return editors;
    }

    private EntityManagerDescriptor getEntityManager(Class objectType) {
        EntityManagerDescriptor manager = this.entityManagerMap.get(objectType.getName());
        if (manager != null) {
            return manager;
        }
        for (EntityManagerDescriptor descriptor : this.entityManagers) {
            if (!descriptor.appliesToType(objectType)) continue;
            return descriptor;
        }
        return null;
    }

    public DBEObjectManager<?> getObjectManager(Class<?> aClass) {
        EntityManagerDescriptor entityManager = this.getEntityManager(aClass);
        return entityManager == null ? null : entityManager.getManager();
    }

    public <T> T getObjectManager(Class<?> objectClass, Class<T> managerType) {
        DBEObjectManager<?> objectManager = this.getObjectManager(objectClass);
        if (objectManager != null && managerType.isAssignableFrom(objectManager.getClass())) {
            return managerType.cast(objectManager);
        }
        return null;
    }
}

