/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.EclipseApplication;
import org.jkiss.dbeaver.core.GlobalProxyAuthenticator;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPProjectManager;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMController;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterRegistry;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.PluginServiceRegistry;
import org.jkiss.dbeaver.registry.ProjectRegistry;
import org.jkiss.dbeaver.registry.datatype.DataTypeProviderRegistry;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.registry.sql.SQLFormatterConfigurationRegistry;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.jobs.KeepAliveJob;
import org.jkiss.dbeaver.runtime.net.GlobalProxySelector;
import org.jkiss.dbeaver.runtime.qm.QMControllerImpl;
import org.jkiss.dbeaver.runtime.qm.QMLogFileWriter;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class DBeaverCore
implements DBPPlatform {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.core";
    public static final String APP_CONFIG_FILE = "dbeaver.ini";
    public static final String ECLIPSE_CONFIG_FILE = "eclipse.ini";
    public static final String TEMP_PROJECT_NAME = ".dbeaver-temp";
    private static final Log log = Log.getLog(DBeaverCore.class);
    private static final DBPApplication DEFAULT_APPLICATION;
    static DBeaverCore instance;
    @NotNull
    private static DBPApplication application;
    private static volatile boolean isClosing;
    private File tempFolder;
    private IWorkspace workspace;
    private DBPPlatformLanguage language;
    private OSDescriptor localSystem;
    private DBNModel navigatorModel;
    private QMControllerImpl queryManager;
    private QMLogFileWriter qmLogWriter;
    private ProjectRegistry projectRegistry;
    private DBACertificateStorage certificateStorage;
    private final List<IPluginService> activatedServices = new ArrayList<IPluginService>();
    private static boolean disposed;

    static {
        application = DEFAULT_APPLICATION = new EclipseApplication();
        isClosing = false;
        disposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBeaverCore getInstance() {
        if (instance != null) return instance;
        Class<DBeaverCore> clazz = DBeaverCore.class;
        synchronized (DBeaverCore.class) {
            if (disposed) {
                throw new IllegalStateException("DBeaver core already disposed");
            }
            if (instance != null) return instance;
            DBeaverCore.createInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static DBeaverCore createInstance() {
        log.debug((Object)("Initializing " + GeneralUtils.getProductTitle()));
        if (Platform.getProduct() != null) {
            Bundle definingBundle = Platform.getProduct().getDefiningBundle();
            if (definingBundle != null) {
                log.debug((Object)("Host plugin: " + definingBundle.getSymbolicName() + " " + definingBundle.getVersion()));
            } else {
                log.debug((Object)"!!! No product bundle found");
            }
        }
        try {
            instance = new DBeaverCore();
            instance.initialize();
            return instance;
        }
        catch (Throwable e) {
            log.error((Object)"Error initializing DBeaverCore", e);
            throw new IllegalStateException("Error initializing DBeaverCore", e);
        }
    }

    public static String getCorePluginID() {
        return DBeaverActivator.getInstance().getBundle().getSymbolicName();
    }

    public static boolean isStandalone() {
        return application.isStandalone();
    }

    public static void setApplication(@NotNull DBPApplication app) {
        application = app;
    }

    public static boolean isClosing() {
        if (isClosing) {
            return true;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench == null || workbench.isClosing();
    }

    public static void setClosing(boolean closing) {
        isClosing = closing;
    }

    public static DBPPreferenceStore getGlobalPreferenceStore() {
        return DBeaverActivator.getInstance().getPreferences();
    }

    DBeaverCore() {
    }

    private void initialize() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Initialize Core...");
        DBPPreferenceStore prefsStore = DBeaverCore.getGlobalPreferenceStore();
        prefsStore.addPropertyChangeListener(new DBPPreferenceListener(){

            public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
                for (DataSourceDescriptor ds : DataSourceRegistry.getAllDataSources()) {
                    ds.getPreferenceStore().firePropertyChangeEvent(event.getProperty(), event.getOldValue(), event.getNewValue());
                }
            }
        });
        this.workspace = ResourcesPlugin.getWorkspace();
        this.localSystem = new OSDescriptor(Platform.getOS(), Platform.getOSArch());
        this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.getDefault());
        if (this.language == null) {
            log.debug((Object)("Language for locale '" + Locale.getDefault() + "' not found. Use default."));
            this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.ENGLISH);
        }
        QMUtils.initApplication((DBPPlatform)this);
        this.queryManager = new QMControllerImpl();
        this.qmLogWriter = new QMLogFileWriter();
        this.queryManager.registerMetaListener(this.qmLogWriter);
        Authenticator.setDefault(new GlobalProxyAuthenticator());
        ProxySelector.setDefault((ProxySelector)new GlobalProxySelector(ProxySelector.getDefault()));
        this.certificateStorage = new DefaultCertificateStorage(new File(DBeaverActivator.getInstance().getStateLocation().toFile(), "security"));
        this.projectRegistry = new ProjectRegistry(this.workspace);
        this.initializeProjects();
        this.navigatorModel = new DBNModel((DBPPlatform)this);
        this.navigatorModel.initialize();
        for (IPluginService pluginService : PluginServiceRegistry.getInstance().getServices()) {
            try {
                pluginService.activateService();
                this.activatedServices.add(pluginService);
            }
            catch (Throwable e) {
                log.error((Object)"Error activating plugin service", e);
            }
        }
        new KeepAliveJob((DBPPlatform)this).scheduleMonitor();
        log.debug((Object)("Core initialized (" + (System.currentTimeMillis() - startTime) + "ms)"));
    }

    private void initializeProjects() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            this.projectRegistry.loadProjects((IProgressMonitor)monitor);
        }
        catch (DBException e) {
            log.error((Object)"Error loading projects", (Throwable)e);
        }
    }

    public synchronized void dispose() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Shutdown Core...");
        DBeaverCore.setClosing(true);
        for (IPluginService pluginService : this.activatedServices) {
            try {
                pluginService.deactivateService();
            }
            catch (Exception e) {
                log.error((Object)"Error deactivating plugin service", (Throwable)e);
            }
        }
        this.activatedServices.clear();
        if (this.navigatorModel != null) {
            this.navigatorModel.dispose();
        }
        if (this.projectRegistry != null) {
            this.projectRegistry.dispose();
            this.projectRegistry = null;
        }
        if (this.qmLogWriter != null) {
            this.queryManager.unregisterMetaListener(this.qmLogWriter);
            this.qmLogWriter.dispose();
            this.qmLogWriter = null;
        }
        if (this.queryManager != null) {
            this.queryManager.dispose();
        }
        DataSourceProviderRegistry.getInstance().dispose();
        if (DBeaverCore.isStandalone() && this.workspace != null) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.workspace.save(true, (IProgressMonitor)monitor);
            }
            catch (CoreException ex) {
                log.error((Object)"Can't save workspace", (Throwable)ex);
            }
        }
        if (this.tempFolder != null) {
            if (!ContentUtils.deleteFileRecursive((File)this.tempFolder)) {
                log.warn((Object)("Can't delete temp folder '" + this.tempFolder.getAbsolutePath() + "'"));
            }
            this.tempFolder = null;
        }
        application = DEFAULT_APPLICATION;
        instance = null;
        disposed = true;
        System.gc();
        log.debug((Object)("Shutdown completed in " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    @NotNull
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public DBPProjectManager getProjectManager() {
        return this.getProjectRegistry();
    }

    public OSDescriptor getLocalSystem() {
        return this.localSystem;
    }

    @NotNull
    public DBPApplication getApplication() {
        return application;
    }

    @NotNull
    public DBPPlatformLanguage getLanguage() {
        return this.language;
    }

    public void setPlatformLanguage(@NotNull DBPPlatformLanguage language) throws DBException {
        File configPath;
        if (CommonUtils.equalObjects((Object)language, (Object)this.language)) {
            return;
        }
        try {
            configPath = RuntimeUtils.getLocalFileFromURL((URL)Platform.getInstallLocation().getURL());
        }
        catch (IOException e) {
            throw new DBException("Can't detect application installation folder.", (Throwable)e);
        }
        File iniFile = new File(configPath, ECLIPSE_CONFIG_FILE);
        if (!iniFile.exists()) {
            iniFile = new File(configPath, APP_CONFIG_FILE);
        }
        if (!iniFile.exists()) {
            throw new DBException("Application configuration file (" + iniFile.getAbsolutePath() + ") not found. Default language cannot be changed.");
        }
        try {
            List<String> configLines = Files.readAllLines(iniFile.toPath());
            this.setConfigNLS(configLines, language.getCode());
            Files.write(iniFile.toPath(), configLines, StandardOpenOption.WRITE);
            this.language = language;
            DBeaverCore.getGlobalPreferenceStore().setValue("platform.language", language.getCode());
        }
        catch (AccessDeniedException e) {
            throw new DBException("Can't save startup configuration - access denied.\nYou could try to change national locale manually in '" + iniFile.getAbsolutePath() + "'. Refer to readme.txt file for details.", (Throwable)e);
        }
        catch (Exception e) {
            throw new DBException("Unexpected error while saving startup configuration", (Throwable)e);
        }
    }

    private void setConfigNLS(List<String> lines, String nl) {
        int vmArgsPos = -1;
        int nlPos = -1;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i).trim();
            if (line.equalsIgnoreCase("-nl")) {
                nlPos = i;
            } else if (line.equalsIgnoreCase("-vmargs")) {
                vmArgsPos = i;
                break;
            }
            ++i;
        }
        if (nlPos >= 0 && lines.size() > nlPos + 1) {
            lines.set(nlPos + 1, nl);
        } else if (vmArgsPos >= 0) {
            lines.add(vmArgsPos, nl);
            lines.add(vmArgsPos, "-nl");
        } else {
            lines.add("-nl");
            lines.add(nl);
        }
    }

    @NotNull
    public DBNModel getNavigatorModel() {
        return this.navigatorModel;
    }

    @NotNull
    public QMController getQueryManager() {
        return this.queryManager;
    }

    @NotNull
    public DBDRegistry getValueHandlerRegistry() {
        return DataTypeProviderRegistry.getInstance();
    }

    @NotNull
    public DBERegistry getEditorsRegistry() {
        return EntityEditorsRegistry.getInstance();
    }

    public SQLFormatterRegistry getSQLFormatterRegistry() {
        return SQLFormatterConfigurationRegistry.getInstance();
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return DBeaverCore.getGlobalPreferenceStore();
    }

    @NotNull
    public DBACertificateStorage getCertificateStorage() {
        return this.certificateStorage;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return application.getSecureStorage();
    }

    public ProjectRegistry getProjectRegistry() {
        return this.projectRegistry;
    }

    public DBPExternalFileManager getExternalFileManager() {
        return this.projectRegistry;
    }

    @NotNull
    public File getTempFolder(DBRProgressMonitor monitor, String name) {
        block3: {
            if (this.tempFolder == null) {
                monitor.subTask("Create temp folder");
                try {
                    Path tempDirectory = Files.createTempDirectory(TEMP_PROJECT_NAME, new FileAttribute[0]);
                    this.tempFolder = tempDirectory.toFile();
                }
                catch (IOException e) {
                    String sysUserFolder;
                    String sysTempFolder = System.getProperty("java.io.tmpdir");
                    if (CommonUtils.isEmpty((String)sysTempFolder)) break block3;
                    this.tempFolder = new File(sysTempFolder, TEMP_PROJECT_NAME);
                    if (this.tempFolder.mkdirs() || CommonUtils.isEmpty((String)(sysUserFolder = System.getProperty("user.home")))) break block3;
                    this.tempFolder = new File(sysUserFolder, TEMP_PROJECT_NAME);
                    if (this.tempFolder.mkdirs()) break block3;
                    this.tempFolder = new File(TEMP_PROJECT_NAME);
                    if (this.tempFolder.mkdirs()) break block3;
                    log.error((Object)"Can't create temp directory!");
                }
            }
        }
        return this.tempFolder;
    }

    public boolean isShuttingDown() {
        return DBeaverCore.isClosing();
    }

    @NotNull
    public List<IProject> getLiveProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = this.workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && !project.isHidden()) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }
}

