/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.AbstractFbWireService;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireService;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;

public class V10Service
extends AbstractFbWireService
implements FbWireService {
    private int handle;

    public V10Service(WireServiceConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach() throws SQLException {
        try {
            this.checkConnected();
            if (this.isAttached()) {
                throw new SQLException("Already attached to a service");
            }
            ServiceParameterBuffer spb = this.protocolDescriptor.createAttachServiceParameterBuffer((WireServiceConnection)this.connection);
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    try {
                        this.sendAttachToBuffer(spb);
                        this.getXdrOut().flush();
                    }
                    catch (IOException e) {
                        throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
                    }
                    try {
                        this.authReceiveResponse(null);
                    }
                    catch (IOException e) {
                        throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
                    }
                }
                catch (SQLException e) {
                    this.safelyDetach();
                    throw e;
                }
                this.setAttached();
                this.afterAttachActions();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void processAttachResponse(GenericResponse genericResponse) {
        this.handle = genericResponse.getObjectHandle();
    }

    protected void afterAttachActions() throws SQLException {
        this.getServiceInfo((ServiceParameterBuffer)null, this.getDescribeServiceRequestBuffer(), 1024, this.getServiceInformationProcessor());
        ((WireServiceConnection)this.connection).resetSocketTimeout();
    }

    protected void sendAttachToBuffer(ServiceParameterBuffer spb) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(82);
        xdrOut.writeInt(0);
        xdrOut.writeString(((WireServiceConnection)this.connection).getAttachObjectName(), this.getEncoding());
        xdrOut.writeTyped(spb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalDetach() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    if (this.isAttached()) {
                        xdrOut.writeInt(83);
                        xdrOut.writeInt(this.getHandle());
                    }
                    xdrOut.writeInt(6);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                if (this.isAttached()) {
                    try {
                        this.wireOperations.readResponse(null);
                    }
                    catch (IOException ex) {
                        throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                    }
                }
                try {
                    this.closeConnection();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
            }
            catch (SQLException ex) {
                try {
                    this.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.setDetached();
            }
        }
    }

    @Override
    public byte[] getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int maxBufferLength) throws SQLException {
        try {
            this.checkAttached();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(84);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(0);
                    xdrOut.writeBuffer(serviceParameterBuffer != null ? serviceParameterBuffer.toBytes() : null);
                    xdrOut.writeBuffer(serviceRequestBuffer.toBytes());
                    xdrOut.writeInt(maxBufferLength);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    GenericResponse genericResponse = this.readGenericResponse(null);
                    return genericResponse.getData();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startServiceAction(ServiceRequestBuffer serviceRequestBuffer) throws SQLException {
        try {
            this.checkAttached();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(85);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(0);
                    xdrOut.writeBuffer(serviceRequestBuffer.toBytes());
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    this.readGenericResponse(null);
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeConnection() throws IOException {
        if (!((WireServiceConnection)this.connection).isConnected()) {
            return;
        }
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                ((WireServiceConnection)this.connection).close();
            }
            finally {
                this.setDetached();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (((WireServiceConnection)this.connection).isConnected()) {
                if (this.isAttached()) {
                    this.safelyDetach();
                } else {
                    this.closeConnection();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket) throws IOException, SQLException {
        this.wireOperations.authReceiveResponse(acceptPacket, new FbWireOperations.ProcessAttachCallback(){

            @Override
            public void processAttachResponse(GenericResponse response) {
                V10Service.this.processAttachResponse(response);
            }
        });
    }
}

