/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataSource;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataType;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdFieldType;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class FireBirdDataTypeCache
extends JDBCBasicDataTypeCache<GenericStructContainer, FireBirdDataType> {
    private static final Log log = Log.getLog(FireBirdDataTypeCache.class);

    public FireBirdDataTypeCache(GenericStructContainer owner) {
        super((DBSObject)owner);
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        ArrayList<FireBirdDataType> tmpObjectList;
        block36: {
            Object fieldType;
            FireBirdDataSource dataSource = (FireBirdDataSource)container.getDataSource();
            if (dataSource == null) {
                throw new DBException("Not connected to database");
            }
            tmpObjectList = new ArrayList<FireBirdDataType>();
            Object object = FireBirdFieldType.values();
            int n = ((FireBirdFieldType[])object).length;
            int n2 = 0;
            while (n2 < n) {
                fieldType = object[n2];
                FireBirdDataType dataType = new FireBirdDataType(dataSource, (FireBirdFieldType)((Object)fieldType));
                tmpObjectList.add(dataType);
                ++n2;
            }
            try {
                try {
                    fieldType = null;
                    Object var6_10 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource.getDataSource(), (String)"Load FireBird domain types");){
                        object = null;
                        Object var9_16 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT F.* FROM RDB$FIELDS F ORDER BY RDB$FIELD_NAME");){
                            monitor.subTask("Load FireBird domain types");
                            Throwable throwable = null;
                            Object var12_21 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.next()) {
                                    if (monitor.isCanceled()) {
                                        break;
                                    }
                                    String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$FIELD_NAME");
                                    if (typeName == null) continue;
                                    int fieldLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_LENGTH");
                                    int fieldScale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_SCALE");
                                    int fieldPrecision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_PRECISION");
                                    int fieldType2 = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_TYPE");
                                    int fieldSubType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_SUB_TYPE");
                                    int charLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$CHARACTER_LENGTH");
                                    int collationId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$COLLATION_ID");
                                    int charsetId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$CHARACTER_SET_ID");
                                    String validationSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$VALIDATION_SOURCE");
                                    String computedSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$COMPUTED_SOURCE");
                                    String typeDescription = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
                                    String defaultSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$DEFAULT_SOURCE");
                                    FireBirdFieldType fieldDT = FireBirdFieldType.getById(fieldType2);
                                    if (fieldDT == null) {
                                        log.error((Object)("Field type '" + fieldType2 + "' not found"));
                                        continue;
                                    }
                                    String charsetName = dataSource.getMetaFieldValue("RDB$CHARACTER_SET_NAME", charsetId);
                                    boolean notNull = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$NULL_FLAG") == 1;
                                    FireBirdDataType dataType = new FireBirdDataType(dataSource, fieldDT, fieldSubType, typeName.trim(), typeDescription, false, true, fieldPrecision, fieldScale, fieldScale, fieldLength, charLength, computedSource, validationSource, defaultSource, charsetName, notNull);
                                    tmpObjectList.add(dataType);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fieldType == null) {
                            fieldType = throwable;
                        } else if (fieldType != throwable) {
                            ((Throwable)fieldType).addSuppressed(throwable);
                        }
                        throw fieldType;
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex, (DBPDataSource)dataSource);
                }
            }
            catch (DBException e) {
                if (this.handleCacheReadError(e)) break block36;
                throw e;
            }
        }
        this.mergeCache(tmpObjectList);
    }
}

