/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OracleTable
extends OracleTablePhysical
implements DBPScriptObject,
DBDPseudoAttributeContainer,
DBPImageProvider {
    private static final Log log = Log.getLog(OracleTable.class);
    private OracleDataType tableType;
    private String iotType;
    private String iotName;
    private boolean temporary;
    private boolean secondary;
    private boolean nested;
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public OracleTable(OracleSchema schema, String name) {
        super(schema, name);
    }

    public OracleTable(DBRProgressMonitor monitor, OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
        String typeOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE_OWNER");
        if (!CommonUtils.isEmpty((String)typeOwner)) {
            this.tableType = OracleDataType.resolveDataType(monitor, schema.getDataSource(), typeOwner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE"));
        }
        this.iotType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IOT_TYPE");
        this.iotName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IOT_NAME");
        this.temporary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TEMPORARY", (String)"Y");
        this.secondary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"SECONDARY", (String)"Y");
        this.nested = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NESTED", (String)"Y");
        CommonUtils.isEmpty((String)this.iotName);
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    protected String getTableTypeName() {
        return "TABLE";
    }

    public boolean isView() {
        return false;
    }

    @Property(viewable=false, order=5)
    public OracleDataType getTableType() {
        return this.tableType;
    }

    @Property(viewable=false, order=6)
    public String getIotType() {
        return this.iotType;
    }

    @Property(viewable=false, order=7)
    public String getIotName() {
        return this.iotName;
    }

    @Property(viewable=false, order=10)
    public boolean isTemporary() {
        return this.temporary;
    }

    @Property(viewable=false, order=11)
    public boolean isSecondary() {
        return this.secondary;
    }

    @Property(viewable=false, order=12)
    public boolean isNested() {
        return this.nested;
    }

    @Override
    public OracleTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return super.getAttribute(monitor, attributeName);
    }

    @Nullable
    private OracleTableColumn getXMLColumn(DBRProgressMonitor monitor) throws DBException {
        for (OracleTableColumn col : CommonUtils.safeCollection(this.getAttributes(monitor))) {
            if (col.getDataType() != this.tableType) continue;
            return col;
        }
        return null;
    }

    @Override
    public Collection<OracleTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<OracleTableForeignKey> refs = new ArrayList<OracleTableForeignKey>();
        Collection allForeignKeys = ((OracleSchema)this.getContainer()).foreignKeyCache.getObjects(monitor, (OracleSchema)this.getContainer(), null);
        for (OracleTableForeignKey constraint : allForeignKeys) {
            if (constraint.getReferencedTable() != this) continue;
            refs.add(constraint);
        }
        return refs;
    }

    @Override
    @Association
    public Collection<OracleTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).foreignKeyCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).foreignKeyCache.clearObjectCache(this);
        return super.refreshObject(monitor);
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (CommonUtils.isEmpty((String)this.iotType) && ((OracleDataSource)this.getDataSource()).getContainer().getPreferenceStore().getBoolean("oracle.support.rowid")) {
            return new DBDPseudoAttribute[]{OracleConstants.PSEUDO_ATTR_ROWID};
        }
        return null;
    }

    protected void appendSelectSource(DBRProgressMonitor monitor, StringBuilder query, String tableAlias, DBDPseudoAttribute rowIdAttribute) {
        if (this.tableType != null && this.tableType.getName().equals("XMLTYPE")) {
            try {
                OracleTableColumn xmlColumn = this.getXMLColumn(monitor);
                if (xmlColumn != null) {
                    query.append("XMLType(").append(tableAlias).append(".").append(xmlColumn.getName()).append(".getClobval()) as ").append(xmlColumn.getName());
                    if (rowIdAttribute != null) {
                        query.append(",").append(rowIdAttribute.translateExpression(tableAlias));
                    }
                    return;
                }
            }
            catch (DBException e) {
                log.warn((Object)e);
            }
        }
        super.appendSelectSource(monitor, query, tableAlias, rowIdAttribute);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDDL(monitor, OracleDDLFormat.getCurrentFormat((OracleDataSource)this.getDataSource()), options);
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (CommonUtils.isEmpty((String)this.iotType)) {
            return DBIcon.TREE_TABLE;
        }
        return DBIcon.TREE_TABLE_INDEX;
    }

    public static class AdditionalInfo
    extends OracleTableBase.TableAdditionalInfo {
    }
}

