/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class OracleStructureAssistant
implements DBSStructureAssistant {
    protected static final Log log = Log.getLog(OracleStructureAssistant.class);
    private final OracleDataSource dataSource;

    public OracleStructureAssistant(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.CONSTRAINT, OracleObjectType.FOREIGN_KEY, OracleObjectType.INDEX, OracleObjectType.PROCEDURE, OracleObjectType.SEQUENCE, OracleObjectType.TRIGGER};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.PROCEDURE};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor monitor, DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        OracleSchema schema = parentObject instanceof OracleSchema ? (OracleSchema)parentObject : null;
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Find objects by name");){
                ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
                this.searchAllObjects(session, schema, objectNameMask, objectTypes, caseSensitive, maxResults, objects);
                if (ArrayUtils.contains((Object[])objectTypes, (Object[])new DBSObjectType[]{OracleObjectType.CONSTRAINT, OracleObjectType.FOREIGN_KEY}) && objects.size() < maxResults) {
                    this.findConstraintsByMask(session, schema, objectNameMask, objectTypes, maxResults, objects);
                }
                final OracleSchema activeSchema = this.dataSource.getDefaultObject();
                Collections.sort(objects, new Comparator<DBSObjectReference>(){

                    @Override
                    public int compare(DBSObjectReference o1, DBSObjectReference o2) {
                        if (CommonUtils.equalObjects((Object)o1.getContainer(), (Object)o2.getContainer())) {
                            return o1.getName().compareTo(o2.getName());
                        }
                        if (o1.getContainer() == null || o1.getContainer() == activeSchema) {
                            return -1;
                        }
                        if (o2.getContainer() == null || o2.getContainer() == activeSchema) {
                            return 1;
                        }
                        return o1.getContainer().getName().compareTo(o2.getContainer().getName());
                    }
                });
                return objects;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
    }

    private void findConstraintsByMask(JDBCSession session, final OracleSchema schema, String constrNameMask, DBSObjectType[] objectTypes, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        List<DBSObjectType> objectTypesList = Arrays.asList(objectTypes);
        final boolean hasFK = objectTypesList.contains((Object)OracleObjectType.FOREIGN_KEY);
        final boolean hasConstraints = objectTypesList.contains((Object)OracleObjectType.CONSTRAINT);
        Throwable throwable = null;
        Object var12_13 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint((OracleDataSource)session.getDataSource()) + " OWNER, TABLE_NAME, CONSTRAINT_NAME, CONSTRAINT_TYPE\n" + "FROM SYS.ALL_CONSTRAINTS\n" + "WHERE CONSTRAINT_NAME like ?" + (!hasFK ? " AND CONSTRAINT_TYPE<>'R'" : "") + (schema != null ? " AND OWNER=?" : ""));){
            dbStat.setString(1, constrNameMask);
            if (schema != null) {
                dbStat.setString(2, schema.getName());
            }
            Throwable throwable2 = null;
            Object var15_18 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    String constrType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
                    final DBSEntityConstraintType type = OracleTableConstraint.getConstraintType(constrType);
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, this.dataSource.getSchema(session.getProgressMonitor(), schemaName), null, type == DBSEntityConstraintType.FOREIGN_KEY ? OracleTableForeignKey.class : OracleTableConstraint.class, type == DBSEntityConstraintType.FOREIGN_KEY ? OracleObjectType.FOREIGN_KEY : OracleObjectType.CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            OracleSchema tableSchema;
                            OracleSchema oracleSchema = tableSchema = schema != null ? schema : OracleStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Constraint schema '" + schemaName + "' not found");
                            }
                            OracleTable table = tableSchema.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Constraint table '" + tableName + "' not found in catalog '" + tableSchema.getName() + "'");
                            }
                            Object constraint = null;
                            if (hasFK && type == DBSEntityConstraintType.FOREIGN_KEY) {
                                constraint = table.getForeignKey(monitor, constrName);
                            }
                            if (hasConstraints && type != DBSEntityConstraintType.FOREIGN_KEY) {
                                constraint = table.getConstraint(monitor, constrName);
                            }
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void searchAllObjects(final JDBCSession session, OracleSchema schema, String objectNameMask, DBSObjectType[] objectTypes, boolean caseSensitive, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        StringBuilder objectTypeClause = new StringBuilder(100);
        ArrayList<OracleObjectType> oracleObjectTypes = new ArrayList<OracleObjectType>(objectTypes.length + 2);
        Object object = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType throwable = object[n2];
            if (throwable instanceof OracleObjectType) {
                oracleObjectTypes.add((OracleObjectType)throwable);
                if (throwable == OracleObjectType.PROCEDURE) {
                    oracleObjectTypes.add(OracleObjectType.FUNCTION);
                } else if (throwable == OracleObjectType.TABLE) {
                    oracleObjectTypes.add(OracleObjectType.VIEW);
                    oracleObjectTypes.add(OracleObjectType.MATERIALIZED_VIEW);
                }
            }
            ++n2;
        }
        for (OracleObjectType oracleObjectType : oracleObjectTypes) {
            if (objectTypeClause.length() > 0) {
                objectTypeClause.append(",");
            }
            objectTypeClause.append("'").append(oracleObjectType.getTypeName()).append("'");
        }
        if (objectTypeClause.length() == 0) {
            return;
        }
        objectTypeClause.append(",'").append(OracleObjectType.SYNONYM.getTypeName()).append("'");
        Throwable throwable = null;
        Iterator iterator = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint((OracleDataSource)session.getDataSource()) + " DISTINCT OWNER,OBJECT_NAME,OBJECT_TYPE FROM (SELECT OWNER,OBJECT_NAME,OBJECT_TYPE FROM ALL_OBJECTS WHERE " + "OBJECT_TYPE IN (" + objectTypeClause + ") AND OBJECT_NAME LIKE ? " + (schema == null ? "" : " AND OWNER=?") + "UNION ALL\n" + "SELECT " + OracleUtils.getSysCatalogHint((OracleDataSource)session.getDataSource()) + " O.OWNER,O.OBJECT_NAME,O.OBJECT_TYPE\n" + "FROM ALL_SYNONYMS S,ALL_OBJECTS O\n" + "WHERE O.OWNER=S.TABLE_OWNER AND O.OBJECT_NAME=S.TABLE_NAME AND S.OWNER='PUBLIC' AND S.SYNONYM_NAME LIKE ?)" + "\nORDER BY OBJECT_NAME");){
            if (!caseSensitive) {
                objectNameMask = objectNameMask.toUpperCase();
            }
            dbStat.setString(1, objectNameMask);
            if (schema != null) {
                dbStat.setString(2, schema.getName());
            }
            dbStat.setString(schema != null ? 3 : 2, objectNameMask);
            dbStat.setFetchSize(1000);
            object = null;
            Object var14_24 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (objects.size() < maxResults && dbResult.next()) {
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                    final String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
                    final String objectTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
                    final OracleObjectType objectType = OracleObjectType.getByType(objectTypeName);
                    if (objectType == null || objectType == OracleObjectType.SYNONYM || !objectType.isBrowsable() || !oracleObjectTypes.contains((Object)objectType)) continue;
                    OracleSchema objectSchema = this.dataSource.getSchema(session.getProgressMonitor(), schemaName);
                    if (objectSchema == null) {
                        log.debug((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(objectName, objectSchema, null, objectType.getTypeClass(), objectType){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            OracleSchema tableSchema = (OracleSchema)this.getContainer();
                            DBSObject object = objectType.findObject(session.getProgressMonitor(), tableSchema, objectName);
                            if (object == null) {
                                throw new DBException(String.valueOf(objectTypeName) + " '" + objectName + "' not found in schema '" + tableSchema.getName() + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable2) {
                if (object == null) {
                    object = throwable2;
                } else if (object != throwable2) {
                    ((Throwable)object).addSuppressed(throwable2);
                }
                throw object;
            }
        }
        catch (Throwable throwable3) {
            void var10_23;
            if (throwable == null) {
                Throwable throwable4 = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw var10_23;
        }
    }
}

