/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;

public class OracleSchemaManager
extends SQLObjectEditor<OracleSchema, OracleDataSource>
implements DBEObjectRenamer<OracleSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleSchema> getObjectsCache(OracleSchema object) {
        return object.getDataSource().schemaCache;
    }

    protected OracleSchema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final OracleDataSource parent, Object copyFrom) {
        return (OracleSchema)new UITask<OracleSchema>(){

            protected OracleSchema runTask() {
                NewUserDialog dialog = new NewUserDialog(DBeaverUI.getActiveWorkbenchShell(), parent);
                if (dialog.open() != 0) {
                    return null;
                }
                OracleSchema newSchema = new OracleSchema(parent, -1L, dialog.getUser().getName());
                newSchema.setUser(dialog.getUser());
                return newSchema;
            }
        }.execute();
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        OracleUser user = ((OracleSchema)command.getObject()).getUser();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", "CREATE USER " + DBUtils.getQuotedIdentifier((DBSObject)user) + " IDENTIFIED BY \"" + user.getPassword() + "\""));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    public void renameObject(DBECommandContext commandContext, OracleSchema schema, String newName) throws DBException {
        throw new DBException("Direct database rename is not yet implemented in Oracle. You should use export/import functions for that.");
    }

    static class NewUserDialog
    extends Dialog {
        private OracleUser user;
        private Text nameText;
        private Text passwordText;

        public NewUserDialog(Shell parentShell, OracleDataSource dataSource) {
            super(parentShell);
            this.user = new OracleUser(dataSource);
        }

        public OracleUser getUser() {
            return this.user;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Set schema/user properties");
            Control container = super.createDialogArea(parent);
            Composite composite = UIUtils.createPlaceholder((Composite)((Composite)container), (int)2);
            composite.setLayoutData((Object)new GridData(1808));
            this.nameText = UIUtils.createLabelText((Composite)composite, (String)"Schema/User Name", null);
            this.nameText.setLayoutData((Object)new GridData(768));
            this.passwordText = UIUtils.createLabelText((Composite)composite, (String)"User Password", null, (int)0x400800);
            this.passwordText.setLayoutData((Object)new GridData(768));
            return parent;
        }

        protected void okPressed() {
            this.user.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)this.user, (String)this.nameText.getText()));
            this.user.setPassword(this.passwordText.getText());
            super.okPressed();
        }
    }
}

