/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.oracle.model.OraclePackage;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureArgument;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedurePackaged;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorNested;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class PackageNavigateHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(PackageNavigateHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        OraclePackage procPackage;
        IEditorPart entityEditor;
        OracleProcedurePackaged procedure = this.getSelectedProcedure(event);
        if (procedure != null && (entityEditor = NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)(procPackage = (OraclePackage)procedure.getParentObject()))) instanceof EntityEditor) {
            ((EntityEditor)entityEditor).switchFolder("source.definition");
            SQLEditorBase sqlEditor = (SQLEditorBase)entityEditor.getAdapter(SQLEditorBase.class);
            if (sqlEditor != null) {
                new NavigateJob(procedure, sqlEditor).schedule();
            }
        }
        return null;
    }

    private OracleProcedurePackaged getSelectedProcedure(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            Object firstElement = ((IStructuredSelection)currentSelection).getFirstElement();
            return (OracleProcedurePackaged)RuntimeUtils.getObjectAdapter((Object)firstElement, OracleProcedurePackaged.class);
        }
        return null;
    }

    static class NavigateJob
    extends AbstractJob {
        private final OracleProcedurePackaged procedure;
        private final SQLEditorBase sqlEditor;

        public NavigateJob(OracleProcedurePackaged procedure, SQLEditorBase sqlEditor) {
            super("Navigate procedure '" + procedure.getFullyQualifiedName(DBPEvaluationContext.UI));
            this.procedure = procedure;
            this.sqlEditor = sqlEditor;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                this.navigate(monitor);
            }
            catch (InterruptedException e) {
                return Status.CANCEL_STATUS;
            }
            catch (DBException e) {
                return GeneralUtils.makeExceptionStatus((Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private void navigate(DBRProgressMonitor monitor) throws InterruptedException, DBException {
            Document document;
            if (this.sqlEditor instanceof SQLEditorNested) {
                int checkAttempts = 0;
                while (!((SQLEditorNested)this.sqlEditor).isDocumentLoaded() && checkAttempts < 10) {
                    Thread.sleep(500L);
                    ++checkAttempts;
                }
            }
            if ((document = this.sqlEditor.getDocument()) != null) {
                String procRegex = String.valueOf(this.procedure.getProcedureType().name()) + "\\s+" + this.procedure.getName();
                Collection<OracleProcedureArgument> parameters = this.procedure.getParameters(monitor);
                if (parameters != null) {
                    ArrayList<OracleProcedureArgument> inParams = new ArrayList<OracleProcedureArgument>();
                    for (OracleProcedureArgument arg : parameters) {
                        if (arg.getParameterKind() == DBSProcedureParameterKind.OUT || arg.isResultArgument()) continue;
                        inParams.add(arg);
                    }
                    if (!inParams.isEmpty()) {
                        procRegex = String.valueOf(procRegex) + "\\s*\\([^\\)]+\\)";
                    }
                }
                FindReplaceDocumentAdapter findAdapter = new FindReplaceDocumentAdapter((IDocument)document);
                try {
                    final IRegion procRegion = findAdapter.find(0, procRegex, true, false, false, true);
                    if (procRegion != null) {
                        DBeaverUI.asyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                sqlEditor.selectAndReveal(procRegion.getOffset(), procRegion.getLength());
                            }
                        });
                    }
                }
                catch (BadLocationException e) {
                    log.error((Object)"Error finding procedure source", (Throwable)e);
                }
            }
        }
    }
}

