/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.views.OracleCompilerDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLogBase;
import org.jkiss.dbeaver.model.exec.compile.DBCSourceHost;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class CompileHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(CompileHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activePart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        List<OracleSourceObject> objects = this.getSelectedObjects(event);
        if (!objects.isEmpty()) {
            EntityEditor entityEditor;
            if (activePart instanceof EntityEditor && (entityEditor = (EntityEditor)activePart).isDirty()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                entityEditor.doSave((IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    return null;
                }
            }
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            if (objects.size() == 1) {
                OracleSourceObject unit = objects.get(0);
                DBCSourceHost sourceHost = null;
                if (activePart != null && (sourceHost = (DBCSourceHost)RuntimeUtils.getObjectAdapter((Object)activePart, DBCSourceHost.class)) == null) {
                    sourceHost = (DBCSourceHost)activePart.getAdapter(DBCSourceHost.class);
                }
                if (sourceHost != null && sourceHost.getSourceObject() != unit) {
                    sourceHost = null;
                }
                DBCCompileLogBase compileLog = sourceHost == null ? new DBCCompileLogBase() : sourceHost.getCompileLog();
                compileLog.clearLog();
                Throwable error = null;
                try {
                    DBeaverUI.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress((DBCCompileLog)compileLog, unit){
                        private final /* synthetic */ DBCCompileLog val$compileLog;
                        private final /* synthetic */ OracleSourceObject val$unit;
                        {
                            this.val$compileLog = dBCCompileLog;
                            this.val$unit = oracleSourceObject;
                        }

                        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                CompileHandler.compileUnit(monitor, this.val$compileLog, this.val$unit);
                            }
                            catch (DBCException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                    if (compileLog.getError() != null) {
                        error = compileLog.getError();
                    }
                }
                catch (InvocationTargetException e) {
                    error = e.getTargetException();
                }
                catch (InterruptedException e) {
                    return null;
                }
                if (error != null) {
                    DBUserInterface.getInstance().showError("Unexpected compilation error", null, error);
                } else if (!CommonUtils.isEmpty((Collection)compileLog.getErrorStack())) {
                    int line = -1;
                    int position = -1;
                    StringBuilder fullMessage = new StringBuilder();
                    for (DBCCompileError oce : compileLog.getErrorStack()) {
                        fullMessage.append(oce.toString()).append(GeneralUtils.getDefaultLineSeparator());
                        if (line >= 0) continue;
                        line = oce.getLine();
                        position = oce.getPosition();
                    }
                    if (sourceHost != null && sourceHost.getSourceObject() == unit && line > 0 && position > 0) {
                        sourceHost.positionSource(line, position);
                        activePart.getSite().getPage().activate((IWorkbenchPart)activePart);
                    }
                    String errorTitle = String.valueOf(unit.getName()) + " compilation failed";
                    if (sourceHost != null) {
                        sourceHost.setCompileInfo(errorTitle, true);
                        sourceHost.showCompileLog();
                    }
                    DBUserInterface.getInstance().showError(errorTitle, fullMessage.toString());
                } else {
                    String message = String.valueOf(unit.getName()) + " compiled successfully";
                    if (sourceHost != null) {
                        sourceHost.setCompileInfo(message, true);
                    }
                    UIUtils.showMessageBox((Shell)activeShell, (String)"Done", (String)message, (int)2);
                }
            } else {
                OracleCompilerDialog dialog = new OracleCompilerDialog(activeShell, objects);
                dialog.open();
            }
        }
        return null;
    }

    private List<OracleSourceObject> getSelectedObjects(ExecutionEvent event) {
        IWorkbenchPart activePart;
        OracleSourceObject sourceObject;
        ArrayList<OracleSourceObject> objects = new ArrayList<OracleSourceObject>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            for (Object element : (IStructuredSelection)currentSelection) {
                OracleSourceObject sourceObject2 = (OracleSourceObject)RuntimeUtils.getObjectAdapter(element, OracleSourceObject.class);
                if (sourceObject2 == null) continue;
                objects.add(sourceObject2);
            }
        }
        if (objects.isEmpty() && (sourceObject = (OracleSourceObject)RuntimeUtils.getObjectAdapter((Object)(activePart = HandlerUtil.getActivePart((ExecutionEvent)event)), OracleSourceObject.class)) != null) {
            objects.add(sourceObject);
        }
        return objects;
    }

    public void updateElement(UIElement element, Map parameters) {
        ArrayList<OracleSourceObject> objects = new ArrayList<OracleSourceObject>();
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite((IServiceLocator)element.getServiceLocator());
        if (partSite != null) {
            IWorkbenchPart activePart;
            OracleSourceObject sourceObject;
            ISelection selection;
            ISelectionProvider selectionProvider = partSite.getSelectionProvider();
            if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
                for (Object item : (IStructuredSelection)selection) {
                    OracleSourceObject sourceObject2 = (OracleSourceObject)RuntimeUtils.getObjectAdapter(item, OracleSourceObject.class);
                    if (sourceObject2 == null) continue;
                    objects.add(sourceObject2);
                }
            }
            if (objects.isEmpty() && (sourceObject = (OracleSourceObject)RuntimeUtils.getObjectAdapter((Object)(activePart = partSite.getPart()), OracleSourceObject.class)) != null) {
                objects.add(sourceObject);
            }
        }
        if (!objects.isEmpty()) {
            if (objects.size() > 1) {
                element.setText("Compile " + objects.size() + " objects");
            } else {
                OracleSourceObject sourceObject = (OracleSourceObject)objects.get(0);
                String objectType = TextUtils.formatWord((String)sourceObject.getSourceType().name());
                element.setText("Compile " + objectType);
            }
        }
    }

    public static boolean compileUnit(DBRProgressMonitor monitor, DBCCompileLog compileLog, OracleSourceObject unit) throws DBCException {
        Object[] compileActions = unit.getCompileActions();
        if (ArrayUtils.isEmpty((Object[])compileActions)) {
            return true;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBPDataSource)unit.getDataSource(), (String)("Compile '" + unit.getName() + "'"));){
            boolean success = true;
            Object[] objectArray = compileActions;
            int n = compileActions.length;
            int n2 = 0;
            while (n2 < n) {
                Object action = objectArray[n2];
                String script = action.getScript();
                compileLog.trace(script);
                if (monitor.isCanceled()) break;
                try {
                    Throwable throwable2 = null;
                    Object var14_18 = null;
                    try (JDBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, script, false, false, false);){
                        action.beforeExecute((DBCSession)session);
                        dbStat.executeStatement();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    action.afterExecute((DBCSession)session, null);
                }
                catch (DBCException e) {
                    action.afterExecute((DBCSession)session, (Throwable)e);
                    throw e;
                }
                if (action instanceof OracleObjectPersistAction && !CompileHandler.logObjectErrors(session, compileLog, unit, ((OracleObjectPersistAction)((Object)action)).getObjectType())) {
                    success = false;
                }
                ++n2;
            }
            DBSObjectState oldState = unit.getObjectState();
            unit.refreshObjectState(monitor);
            if (unit.getObjectState() != oldState) {
                unit.getDataSource().getContainer().fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)unit));
            }
            return success;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean logObjectErrors(JDBCSession session, DBCCompileLog compileLog, OracleSourceObject unit, OracleObjectType objectType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

