/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMKeyProvider;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseListener;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMLicenseValidator;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LMLicenseManager {
    private static final Logger log = Logger.getLogger("LMLicenseManager");
    private final LMKeyProvider keyProvider;
    private final LMLicenseValidator validator;
    private final File configPath;
    private final Map<String, LMLicense[]> licenseCache = new HashMap<String, LMLicense[]>();
    private final List<LMLicenseListener> licenseListeners = new ArrayList<LMLicenseListener>();
    private static File licensePath;

    public static void setLicensePath(String path) {
        licensePath = new File(path);
    }

    public LMLicenseManager(LMKeyProvider keyProvider, LMLicenseValidator validator) {
        this.keyProvider = keyProvider;
        this.validator = validator;
        this.configPath = new File(System.getProperty("user.home"), ".jkiss-lm");
        if (licensePath == null && !this.configPath.exists() && !this.configPath.mkdirs()) {
            log.severe("Can't create LM config directory '" + this.configPath.getAbsolutePath() + "'");
        }
    }

    public void addLicenseListener(LMLicenseListener listener) {
        boolean add;
        if (listener == null) {
            log.severe("Ignored attempt to add null LMLicenseListener");
            return;
        }
        boolean remove = this.licenseListeners.remove(listener);
        if (remove) {
            log.warning(String.format("Removed existing LMLicenseListener %s", listener));
        }
        if (add = this.licenseListeners.add(listener)) {
            log.fine(String.format("Added LMLicenseListener %s", listener));
        } else {
            log.severe(String.format("Failed to add LMLicenseListener %s", listener));
        }
    }

    public void removeLicenseListener(LMLicenseListener listener) {
        if (listener == null) {
            log.severe("Ignored attempt to remove null LMLicenseListener");
            return;
        }
        boolean remove = this.licenseListeners.remove(listener);
        if (remove) {
            log.fine(String.format("Removed LMLicenseListener %s", listener));
        } else {
            log.warning(String.format("Nothing to remove for LMLicenseListener %s", listener));
        }
    }

    protected void fireLicenseChanged(String id, LMLicense[] value) {
        LMLicense[] copy = Arrays.copyOf(value, value.length);
        for (LMLicenseListener listener : this.licenseListeners) {
            try {
                listener.licenseChanged(id, copy);
            }
            catch (Throwable t) {
                String pattern = "Error while processing licenseChanged for %s";
                String message = String.format(pattern, listener);
                log.log(Level.SEVERE, message, t);
            }
        }
    }

    @NotNull
    public LMLicense[] getProductLicenses(@NotNull LMProduct product) {
        String id = product.getId();
        LMLicense[] licenses = this.licenseCache.get(id);
        if (licenses != null) {
            return licenses;
        }
        licenses = this.readProductLicenses(product);
        this.licenseCache.put(id, licenses);
        this.fireLicenseChanged(id, licenses);
        return licenses;
    }

    public void importLicense(@NotNull LMProduct product, @NotNull byte[] licenseData) throws LMException {
        Key decryptionKey = this.keyProvider.getDecryptionKey(product);
        String id = product.getId();
        if (decryptionKey == null) {
            throw new LMException("Product '" + id + "' decryption key not found");
        }
        LMLicense license = new LMLicense(licenseData, decryptionKey);
        if (!id.equals(license.getProductId())) {
            throw new LMException("License (" + license.getProductId() + ") doesn't match product (" + id + ")");
        }
        Object[] cache = this.getProductLicenses(product);
        if (license.getLicenseType() == LMLicenseType.TRIAL) {
            Object[] objectArray = cache;
            int n = cache.length;
            int n2 = 0;
            while (n2 < n) {
                LMLicense oldLic = objectArray[n2];
                if (oldLic.getLicenseType() == LMLicenseType.TRIAL && oldLic.getProductVersion().equalsIgnoreCase(license.getProductVersion())) {
                    throw new LMException("You can't import trial license for " + license.getProductId() + " " + license.getProductVersion() + " more than once");
                }
                ++n2;
            }
        }
        boolean updated = false;
        int i = 0;
        while (i < cache.length) {
            if (cache[i].getLicenseId().equals(license.getLicenseId())) {
                cache[i] = license;
                updated = true;
                break;
            }
            ++i;
        }
        if (!updated) {
            cache = (LMLicense[])ArrayUtils.add(LMLicense.class, (Object[])cache, (Object)license);
        }
        this.licenseCache.put(id, (LMLicense[])cache);
        this.saveProductLicenses(product);
        this.fireLicenseChanged(id, (LMLicense[])cache);
    }

    private void saveProductLicenses(LMProduct product) throws LMException {
        File prodLicenseFile = this.getProductLicensesFile(product);
        LMLicense[] cache = this.licenseCache.get(product.getId());
        if (cache == null || cache.length == 0) {
            if (prodLicenseFile.exists() && !prodLicenseFile.delete()) {
                log.warning("Can't delete licenses file '" + prodLicenseFile.getAbsolutePath() + "'");
            }
        } else {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileOutputStream out = new FileOutputStream(prodLicenseFile);){
                    XMLBuilder xml = new XMLBuilder((OutputStream)out, "utf-8");
                    xml.setButify(true);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (XMLBuilder.Element el1 = xml.startElement("product");){
                        xml.addAttribute("id", product.getId());
                        LMLicense[] lMLicenseArray = cache;
                        int n = cache.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LMLicense license = lMLicenseArray[n2];
                            byte[] encodedData = license.getEncoded();
                            if (encodedData == null) {
                                log.warning("License '" + license.getLicenseId() + "' is not encoded");
                            } else {
                                Throwable throwable3 = null;
                                Object var17_23 = null;
                                try (XMLBuilder.Element el2 = xml.startElement("license");){
                                    xml.addAttribute("type", "standard");
                                    xml.addText((CharSequence)Base64.encode((byte[])encodedData));
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                    xml.flush();
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new LMException("IO error while saving license file", e);
            }
        }
    }

    @NotNull
    private LMLicense[] readProductLicenses(@NotNull LMProduct product) {
        File prodLicenseFile;
        ArrayList<LMLicense> licenses = new ArrayList<LMLicense>();
        if (licensePath != null && licensePath.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileReader in = new FileReader(licensePath);){
                    String licenseEncoded = IOUtils.readToString((Reader)in);
                    LMLicense license = this.readStandardLicense(product, licenseEncoded);
                    if (license != null) {
                        licenses.add(license);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.warning("Error loading custom license from " + licensePath.getAbsolutePath());
            }
        }
        if (licenses.isEmpty() && (prodLicenseFile = this.getProductLicensesFile(product)).exists()) {
            try {
                Document document = XMLUtils.parseDocument((File)prodLicenseFile);
                Element rootElement = document.getDocumentElement();
                if (!"product".equals(rootElement.getTagName()) || !product.getId().equals(rootElement.getAttribute("id"))) {
                    throw new LMException("Bad license file structure");
                }
                for (Element licenseElement : XMLUtils.getChildElementList((Element)rootElement, (String)"license")) {
                    String licenseType = licenseElement.getAttribute("type");
                    if (licenseType == null) {
                        log.warning("No license type");
                        continue;
                    }
                    String licenseEncoded = XMLUtils.getElementBody((Element)licenseElement);
                    if ("standard".equals(licenseType) && licenseEncoded != null) {
                        LMLicense license = this.readStandardLicense(product, licenseEncoded);
                        if (license == null) continue;
                        licenses.add(license);
                        continue;
                    }
                    log.warning("Unsupported license type: " + licenseType);
                }
            }
            catch (LMException | XMLException e) {
                log.log(Level.SEVERE, "Error parse product license file '" + prodLicenseFile, e);
            }
        }
        return licenses.toArray(new LMLicense[licenses.size()]);
    }

    @NotNull
    private File getProductLicensesFile(@NotNull LMProduct product) {
        return new File(this.configPath, String.valueOf(product.getId()) + ".lic");
    }

    private LMLicense readStandardLicense(@NotNull LMProduct product, @NotNull String licenseEncoded) throws LMException {
        byte[] licenseEncrypted;
        Key decryptionKey = this.keyProvider.getDecryptionKey(product);
        if (decryptionKey == null) {
            throw new LMException("Product '" + product.getId() + "' decryption key not found");
        }
        try {
            licenseEncrypted = LMUtils.readEncryptedString(new StringReader(licenseEncoded));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error reading license", e);
            return null;
        }
        try {
            return new LMLicense(licenseEncrypted, decryptionKey);
        }
        catch (LMException e) {
            log.log(Level.SEVERE, "Error parsing license", e);
            return null;
        }
    }

    public LMLicense getValidProductLicense(@NotNull LMProduct product) throws LMValidateException {
        LMLicense[] licenses = this.getProductLicenses(product);
        if (licenses.length == 0) {
            return null;
        }
        LMValidateException validateError = null;
        ArrayList<LMLicense> validLicenses = new ArrayList<LMLicense>();
        LMLicense[] lMLicenseArray = licenses;
        int n = licenses.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                LMLicense license = lMLicenseArray[n2];
                if (license.isValidFor(product, true)) {
                    if (this.validator != null) {
                        try {
                            this.validator.validateLicense(product, license);
                        }
                        catch (LMValidateException e) {
                            validateError = e;
                            break block10;
                        }
                    }
                    validLicenses.add(license);
                }
            }
            ++n2;
        }
        if (validLicenses.isEmpty()) {
            if (validateError != null) {
                throw validateError;
            }
            return null;
        }
        validLicenses.sort((o1, o2) -> {
            int cmp = o1.getProductVersion().compareTo(o2.getProductVersion());
            if (cmp != 0) {
                return cmp;
            }
            return o1.getLicenseIssueTime().compareTo(o2.getLicenseIssueTime());
        });
        int i = validLicenses.size();
        while (i > 0) {
            LMLicense license = (LMLicense)validLicenses.get(i - 1);
            if (license.getLicenseType() != LMLicenseType.TRIAL) {
                return license;
            }
            --i;
        }
        return (LMLicense)validLicenses.get(validLicenses.size() - 1);
    }

    public boolean hasProductLicense(@NotNull LMProduct product) throws LMValidateException {
        return this.getValidProductLicense(product) != null;
    }

    public LMLicense findTrialLicense(LMProduct product) throws LMValidateException {
        LMLicense[] licenses;
        LMValidateException validateError = null;
        LMLicense[] lMLicenseArray = licenses = this.getProductLicenses(product);
        int n = licenses.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                LMLicense license = lMLicenseArray[n2];
                if (license.getLicenseType() == LMLicenseType.TRIAL && license.isValidFor(product, false)) {
                    if (this.validator != null) {
                        try {
                            this.validator.validateLicense(product, license);
                        }
                        catch (LMValidateException e) {
                            validateError = e;
                            break block7;
                        }
                    }
                    return license;
                }
            }
            ++n2;
        }
        if (validateError != null) {
            if (validateError.getStatus() == LMLicenseStatus.EXPIRED) {
                return null;
            }
            throw validateError;
        }
        return null;
    }

    public void deleteLicense(@NotNull LMProduct product, @NotNull LMLicense license) throws LMException {
        LMLicense[] cache = this.getProductLicenses(product);
        ArrayList<LMLicense> newCache = new ArrayList<LMLicense>();
        int i = 0;
        while (i < cache.length) {
            if (!cache[i].getLicenseId().equals(license.getLicenseId())) {
                newCache.add(cache[i]);
            }
            ++i;
        }
        String id = product.getId();
        LMLicense[] value = newCache.toArray(new LMLicense[newCache.size()]);
        this.licenseCache.put(id, value);
        this.saveProductLicenses(product);
        this.fireLicenseChanged(id, value);
    }

    public void validateLicense(LMProduct product, LMLicense license) throws LMValidateException {
        if (this.validator != null) {
            this.validator.validateLicense(product, license);
        }
    }
}

