/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tools;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;

class DB2ToolShowErrorDialog
extends Dialog {
    private final DB2DataSource db2DataSource;
    private Text textSqlErrorCode;
    private Text resultMessage;

    public DB2ToolShowErrorDialog(IWorkbenchWindow window, DB2DataSource db2DataSource) {
        super(window.getShell());
        this.db2DataSource = db2DataSource;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DB2Messages.dialog_tools_msg_title);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container1 = UIUtils.createPlaceholder((Composite)area, (int)3, (int)5);
        UIUtils.createLabel((Composite)container1, (String)DB2Messages.dialog_tools_msg_code);
        this.textSqlErrorCode = new Text(container1, 2048);
        Button button = new Button(container1, 8);
        button.setText("Retrieve Message");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer sqlIntegerCode = 0;
                try {
                    sqlIntegerCode = Integer.valueOf(DB2ToolShowErrorDialog.this.textSqlErrorCode.getText());
                }
                catch (NumberFormatException nfe) {
                    DBUserInterface.getInstance().showError(DB2Messages.dialog_tools_mes_error_code_title, DB2Messages.dialog_tools_mes_error_code);
                    return;
                }
                try {
                    String msg = DB2Utils.getMessageFromCode(DB2ToolShowErrorDialog.this.db2DataSource, sqlIntegerCode);
                    DB2ToolShowErrorDialog.this.resultMessage.setText(msg);
                }
                catch (Exception e1) {
                    DB2ToolShowErrorDialog.this.resultMessage.setText(e1.getMessage());
                }
            }
        });
        this.getShell().setDefaultButton(button);
        UIUtils.createControlLabel((Composite)container1, (String)DB2Messages.dialog_tools_mes_message);
        this.resultMessage = new Text(container1, 2626);
        this.resultMessage.setLayoutData((Object)new GridData(1808));
        this.resultMessage.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 600;
        gd.heightHint = 80;
        this.resultMessage.setLayoutData((Object)gd);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }
}

