/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2DataTypeMetaType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class DB2DataType
extends DB2Object<DBSObject>
implements DBSDataType,
DBPQualifiedObject {
    private static final Log LOG = Log.getLog(DB2DataType.class);
    private static final Map<String, TypeDesc> PREDEFINED_TYPES = new HashMap<String, TypeDesc>(32);
    private DBSObject parentNode;
    private DB2Schema db2Schema;
    private String fullyQualifiedName;
    private TypeDesc typeDesc;
    private Integer db2TypeId;
    private String ownerCol;
    private DB2OwnerType ownerType;
    private String sourceSchemaName;
    private String sourceModuleName;
    private String sourceName;
    private DB2DataTypeMetaType metaType;
    private Integer length;
    private Integer scale;
    private Timestamp createTime;
    private Timestamp alterTime;
    private Timestamp lastRegenTime;
    private String constraintText;
    private String remarks;
    private DB2Module db2Module;

    static {
        PREDEFINED_TYPES.put("ARRAY", new TypeDesc(DBPDataKind.ARRAY, 2003, null, null, null));
        PREDEFINED_TYPES.put("BIGINT", new TypeDesc(DBPDataKind.NUMERIC, -5, 20, 0, 0));
        PREDEFINED_TYPES.put("BINARY", new TypeDesc(DBPDataKind.BINARY, -2, 254, null, null));
        PREDEFINED_TYPES.put("BLOB", new TypeDesc(DBPDataKind.CONTENT, 2004, Integer.MAX_VALUE, null, null));
        PREDEFINED_TYPES.put("BOOLEAN", new TypeDesc(DBPDataKind.BOOLEAN, 16, null, null, null));
        PREDEFINED_TYPES.put("CHARACTER", new TypeDesc(DBPDataKind.STRING, 1, 254, null, null));
        PREDEFINED_TYPES.put("CLOB", new TypeDesc(DBPDataKind.CONTENT, 2005, Integer.MAX_VALUE, null, null));
        PREDEFINED_TYPES.put("DATE", new TypeDesc(DBPDataKind.DATETIME, 91, 10, null, null));
        PREDEFINED_TYPES.put("DBCLOB", new TypeDesc(DBPDataKind.CONTENT, 2005, 0x3FFFFFFF, null, null));
        PREDEFINED_TYPES.put("DECIMAL", new TypeDesc(DBPDataKind.NUMERIC, 3, 31, 0, 31));
        PREDEFINED_TYPES.put("DOUBLE", new TypeDesc(DBPDataKind.NUMERIC, 8, 53, 0, 0));
        PREDEFINED_TYPES.put("GRAPHIC", new TypeDesc(DBPDataKind.STRING, 1, 127, null, null));
        PREDEFINED_TYPES.put("INTEGER", new TypeDesc(DBPDataKind.NUMERIC, 4, 10, 0, 0));
        PREDEFINED_TYPES.put("LONG VARCHAR", new TypeDesc(DBPDataKind.STRING, -1, 32700, null, null));
        PREDEFINED_TYPES.put("LONG VARGRAPHIC", new TypeDesc(DBPDataKind.STRING, -1, 16350, null, null));
        PREDEFINED_TYPES.put("REAL", new TypeDesc(DBPDataKind.NUMERIC, 7, 24, 0, 0));
        PREDEFINED_TYPES.put("REFERENCE", new TypeDesc(DBPDataKind.REFERENCE, 2006, null, null, null));
        PREDEFINED_TYPES.put("ROW", new TypeDesc(DBPDataKind.STRUCT, -8, null, null, null));
        PREDEFINED_TYPES.put("SMALLINT", new TypeDesc(DBPDataKind.NUMERIC, 5, 5, 0, 0));
        PREDEFINED_TYPES.put("TIME", new TypeDesc(DBPDataKind.DATETIME, 92, 8, 0, 0));
        PREDEFINED_TYPES.put("TIMESTAMP", new TypeDesc(DBPDataKind.DATETIME, 93, 32, 0, 12));
        PREDEFINED_TYPES.put("VARBINARY", new TypeDesc(DBPDataKind.BINARY, -3, 32762, null, null));
        PREDEFINED_TYPES.put("VARCHAR", new TypeDesc(DBPDataKind.STRING, 12, 4000, null, null));
        PREDEFINED_TYPES.put("VARGRAPHIC", new TypeDesc(DBPDataKind.STRING, 12, 16336, null, null));
        PREDEFINED_TYPES.put("XML", new TypeDesc(DBPDataKind.CONTENT, 2009, null, null, null));
        PREDEFINED_TYPES.put("CURSOR", new TypeDesc(DBPDataKind.UNKNOWN, -100008, null, null, null));
        PREDEFINED_TYPES.put("DECFLOAT", new TypeDesc(DBPDataKind.NUMERIC, -100001, 34, 0, 0));
    }

    public DB2DataType(DBSObject owner, ResultSet dbResult) throws DBException {
        super(owner, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPENAME"), true);
        DB2DataSource db2DataSource = (DB2DataSource)owner.getDataSource();
        this.db2TypeId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TYPEID");
        this.ownerCol = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.sourceSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCESCHEMA");
        this.sourceName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SOURCENAME");
        this.metaType = (DB2DataTypeMetaType)CommonUtils.valueOf(DB2DataTypeMetaType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"METATYPE"));
        this.length = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"LENGTH");
        this.scale = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SCALE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV9_7()) {
            this.sourceModuleName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCEMODULENAME");
        }
        if (db2DataSource.isAtLeastV10_5()) {
            this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
            this.constraintText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TEXT");
        }
        if (owner instanceof DB2Schema) {
            this.db2Schema = (DB2Schema)owner;
        } else if (owner instanceof DB2Module) {
            this.db2Schema = ((DB2Module)owner).getSchema();
            String typeModuleName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPEMODULENAME");
            if (typeModuleName != null) {
                this.db2Module = DB2Utils.findModuleBySchemaNameAndName((DBRProgressMonitor)new VoidProgressMonitor(), db2DataSource, this.db2Schema.getName(), typeModuleName);
            }
        } else {
            String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPESCHEMA");
            try {
                this.db2Schema = db2DataSource.getSchema((DBRProgressMonitor)new VoidProgressMonitor(), schemaName);
            }
            catch (DBException e) {
                LOG.error((Object)("Impossible! Schema '" + schemaName + "' for dataType '" + this.name + "' not found??"), (Throwable)e);
            }
        }
        this.fullyQualifiedName = this.db2Schema != null && this.db2Schema.getName().equals("SYSIBM") ? this.name : String.valueOf(this.db2Schema.getName()) + "." + this.name;
        TypeDesc tempTypeDesc = null;
        if (this.db2Schema.getName().equals("SYSIBM")) {
            tempTypeDesc = PREDEFINED_TYPES.get(this.name);
        }
        if (tempTypeDesc == null) {
            switch (this.metaType) {
                case R: {
                    tempTypeDesc = new TypeDesc(DBPDataKind.STRUCT, 2002, null, null, null);
                    break;
                }
                case A: 
                case L: {
                    tempTypeDesc = new TypeDesc(DBPDataKind.ARRAY, 2003, null, null, null);
                    break;
                }
                default: {
                    if (this.sourceSchemaName != null && this.sourceSchemaName.equals("SYSIBM")) {
                        LOG.debug((Object)(String.valueOf(this.name) + " is a User Defined Type base on a System Data Type."));
                        tempTypeDesc = PREDEFINED_TYPES.get(this.sourceName);
                        break;
                    }
                    LOG.debug((Object)(String.valueOf(this.name) + " is a User Defined Type base on another UDT. Set its DBPDataKind to UNKNOWN/OTHER"));
                    tempTypeDesc = new TypeDesc(DBPDataKind.UNKNOWN, 1111, null, null, null);
                }
            }
        }
        this.typeDesc = tempTypeDesc;
        if (this.parent instanceof DB2Schema || this.parent instanceof DB2Module) {
            this.parentNode = this.parent;
        } else if (this.parent instanceof DB2DataSource) {
            this.parentNode = ((DB2DataSource)this.parent).getContainer();
        }
    }

    @Override
    public DBSObject getParentObject() {
        return this.parentNode;
    }

    public String getTypeName() {
        return this.name;
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.fullyQualifiedName;
    }

    public int getEquivalentSqlType() {
        return this.typeDesc.sqlType;
    }

    public Integer getPrecision() {
        if (this.typeDesc.precision != null) {
            return this.typeDesc.precision;
        }
        return 0;
    }

    @Nullable
    public Object geTypeExtension() {
        return this.metaType;
    }

    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public int getMinScale() {
        if (this.typeDesc.minScale != null) {
            return this.typeDesc.minScale;
        }
        return 0;
    }

    public int getMaxScale() {
        if (this.typeDesc.maxScale != null) {
            return this.typeDesc.maxScale;
        }
        return 0;
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators((DBSTypedObject)this);
    }

    @Override
    @Property(viewable=true, editable=false, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2Schema getSchema() {
        return this.db2Schema;
    }

    @Property(viewable=true, editable=false, order=3)
    public DB2Module getModule() {
        return this.db2Module;
    }

    @Property(viewable=true, editable=false, order=4)
    public DBPDataKind getDataKind() {
        return this.typeDesc == null ? DBPDataKind.UNKNOWN : this.typeDesc.dataKind;
    }

    @Property(viewable=false, editable=false, order=5)
    public DB2DataTypeMetaType getMetaType() {
        return this.metaType;
    }

    @Property(viewable=true, editable=false, order=5)
    public long getMaxLength() {
        return this.length.intValue();
    }

    @Property(viewable=true, editable=false, order=6)
    public Integer getScale() {
        return this.scale;
    }

    @Property(viewable=false, editable=false, order=10)
    public int getTypeID() {
        return this.typeDesc.sqlType;
    }

    @Property(viewable=false, editable=false, order=11)
    public Integer getDb2TypeId() {
        return this.db2TypeId;
    }

    @Property(viewable=false, editable=false)
    public String getConstraintText() {
        return this.constraintText;
    }

    @Override
    @Property(viewable=false, editable=false)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(viewable=false, editable=false, category="Source", order=20)
    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    @Property(viewable=false, editable=false, category="Source", order=21)
    public String getSourceModuleName() {
        return this.sourceModuleName;
    }

    @Property(viewable=false, editable=false, category="Source", order=22)
    public String getSourceName() {
        return this.sourceName;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.ownerCol;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }

    private static final class TypeDesc {
        private final DBPDataKind dataKind;
        private final Integer sqlType;
        private final Integer precision;
        private final Integer minScale;
        private final Integer maxScale;

        private TypeDesc(DBPDataKind dataKind, Integer sqlType, Integer precision, Integer minScale, Integer maxScale) {
            this.dataKind = dataKind;
            this.sqlType = sqlType;
            this.precision = precision;
            this.minScale = minScale;
            this.maxScale = maxScale;
        }
    }
}

