/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.ext.db2.DB2DataSourceProvider;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.DB2SQLDialect;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.editors.DB2StructureAssistant;
import org.jkiss.dbeaver.ext.db2.editors.DB2TablespaceChooser;
import org.jkiss.dbeaver.ext.db2.info.DB2Parameter;
import org.jkiss.dbeaver.ext.db2.info.DB2XMLString;
import org.jkiss.dbeaver.ext.db2.model.DB2Bufferpool;
import org.jkiss.dbeaver.ext.db2.model.DB2CurrentUserPrivileges;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSourceInfo;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2StorageGroup;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Variable;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2RemoteServer;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2UserMapping;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Wrapper;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanAnalyser;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIDType;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GranteeCache;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Role;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DB2DataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBCQueryPlanner,
IAdaptable {
    private static final Log LOG = Log.getLog(DB2DataSource.class);
    private static final String GET_CURRENT_USER = "VALUES(SYSTEM_USER)";
    private static final String GET_CURRENT_SCHEMA = "VALUES(CURRENT SCHEMA)";
    private static final String SET_CURRENT_SCHEMA = "SET CURRENT SCHEMA = %s";
    private static final String GET_SESSION_USER = "VALUES(SESSION_USER)";
    private static final String C_SCHEMA = "SELECT * FROM SYSCAT.SCHEMATA ORDER BY SCHEMANAME WITH UR";
    private static final String C_DT = "SELECT * FROM SYSCAT.DATATYPES WHERE METATYPE = 'S' ORDER BY TYPESCHEMA,TYPENAME WITH UR";
    private static final String C_BP = "SELECT * FROM SYSCAT.BUFFERPOOLS ORDER BY BPNAME WITH UR";
    private static final String C_TS = "SELECT * FROM SYSCAT.TABLESPACES ORDER BY TBSPACE WITH UR";
    private static final String C_SG = "SELECT * FROM SYSCAT.STOGROUPS ORDER BY SGNAME WITH UR";
    private static final String C_RL = "SELECT * FROM SYSCAT.ROLES ORDER BY ROLENAME WITH UR";
    private static final String C_VR = "SELECT * FROM SYSCAT.VARIABLES WHERE VARMODULENAME IS NULL ORDER BY VARNAME WITH UR";
    private static final String C_SV = "SELECT * FROM SYSCAT.SERVERS ORDER BY SERVERNAME WITH UR";
    private static final String C_WR = "SELECT * FROM SYSCAT.WRAPPERS ORDER BY WRAPNAME WITH UR";
    private static final String C_UM = "SELECT * FROM SYSCAT.USEROPTIONS WHERE OPTION = 'REMOTE_AUTHID' ORDER BY SERVERNAME,AUTHID WITH UR";
    private final DBSObjectCache<DB2DataSource, DB2Schema> schemaCache = new JDBCObjectSimpleCache(DB2Schema.class, "SELECT * FROM SYSCAT.SCHEMATA ORDER BY SCHEMANAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2DataType> dataTypeCache = new JDBCObjectSimpleCache(DB2DataType.class, "SELECT * FROM SYSCAT.DATATYPES WHERE METATYPE = 'S' ORDER BY TYPESCHEMA,TYPENAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Bufferpool> bufferpoolCache = new JDBCObjectSimpleCache(DB2Bufferpool.class, "SELECT * FROM SYSCAT.BUFFERPOOLS ORDER BY BPNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Tablespace> tablespaceCache = new JDBCObjectSimpleCache(DB2Tablespace.class, "SELECT * FROM SYSCAT.TABLESPACES ORDER BY TBSPACE WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2RemoteServer> remoteServerCache = new JDBCObjectSimpleCache(DB2RemoteServer.class, "SELECT * FROM SYSCAT.SERVERS ORDER BY SERVERNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Wrapper> wrapperCache = new JDBCObjectSimpleCache(DB2Wrapper.class, "SELECT * FROM SYSCAT.WRAPPERS ORDER BY WRAPNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2UserMapping> userMappingCache = new JDBCObjectSimpleCache(DB2UserMapping.class, "SELECT * FROM SYSCAT.USEROPTIONS WHERE OPTION = 'REMOTE_AUTHID' ORDER BY SERVERNAME,AUTHID WITH UR", new Object[0]);
    private final DB2GranteeCache groupCache = new DB2GranteeCache(DB2AuthIDType.G);
    private final DB2GranteeCache userCache = new DB2GranteeCache(DB2AuthIDType.U);
    private final DBSObjectCache<DB2DataSource, DB2StorageGroup> storagegroupCache = new JDBCObjectSimpleCache(DB2StorageGroup.class, "SELECT * FROM SYSCAT.STOGROUPS ORDER BY SGNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Role> roleCache = new JDBCObjectSimpleCache(DB2Role.class, "SELECT * FROM SYSCAT.ROLES ORDER BY ROLENAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Variable> variableCache = new JDBCObjectSimpleCache(DB2Variable.class, "SELECT * FROM SYSCAT.VARIABLES WHERE VARMODULENAME IS NULL ORDER BY VARNAME WITH UR", new Object[0]);
    private List<DB2Parameter> listDBParameters;
    private List<DB2Parameter> listDBMParameters;
    private List<DB2XMLString> listXMLStrings;
    private String activeSchemaName;
    private DB2CurrentUserPrivileges db2CurrentUserPrivileges;
    private String schemaForExplainTables;
    private Double version;

    public DB2DataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new DB2SQLDialect());
    }

    protected boolean isConnectionReadOnlyBroken() {
        return true;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                this.activeSchemaName = this.determineActiveSchema(session);
                this.db2CurrentUserPrivileges = new DB2CurrentUserPrivileges(monitor, session, this.activeSchemaName, this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error reading active schema", (Throwable)e);
        }
        try {
            this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBException e) {
            LOG.warn((Object)"Error reading types info", (Throwable)e);
            this.dataTypeCache.setCache(Collections.emptyList());
        }
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        if (setActiveObject) {
            this.setCurrentSchema(monitor, context, this.getDefaultObject());
        }
    }

    private String determineActiveSchema(JDBCSession session) throws SQLException {
        String defSchema = JDBCUtils.queryString((JDBCSession)session, (String)GET_CURRENT_SCHEMA, (Object[])new Object[0]);
        if (defSchema == null) {
            LOG.warn((Object)"VALUES(CURRENT SCHEMA) returned null! How can it be? Trying to set active schema to special register 'SYSTEM_USER'");
            defSchema = JDBCUtils.queryString((JDBCSession)session, (String)GET_CURRENT_USER, (Object[])new Object[0]);
            if (defSchema == null) {
                LOG.warn((Object)"Special registers 'CURRENT SCHEMA' and 'SYSTEM_USER' both returned null. Use connection username as active schema");
                defSchema = this.getContainer().getActualConnectionConfiguration().getUserName();
            }
        }
        return defSchema.trim();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new DB2StructureAssistant(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    protected String getConnectionUserName(@NotNull DBPConnectionConfiguration connectionInfo) {
        return connectionInfo.getUserName();
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return this;
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        DB2DataSourceInfo info = new DB2DataSourceInfo(metaData);
        this.version = DB2Constants.DB2v9_1;
        try {
            this.version = Integer.valueOf(metaData.getDatabaseMajorVersion()).doubleValue();
            this.version = this.version + Integer.valueOf(metaData.getDatabaseMinorVersion()).doubleValue() / 10.0;
        }
        catch (SQLException e) {
            LOG.warn((Object)("SQLException when reading database version. Set it to lowest supported version : " + DB2Constants.DB2v9_1 + " : " + e.getMessage()));
        }
        LOG.debug((Object)(String.valueOf(this.getName()) + " is version v" + this.version));
        info.setSupportsResultSetScroll(false);
        return info;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, String purpose) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(DB2DataSourceProvider.getConnectionsProps());
        if (this.getContainer().isConnectionReadOnly()) {
            props.put("readOnly", "true");
        }
        return props;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBCException {
        Connection db2Connection = super.openConnection(monitor, purpose);
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                db2Connection.setClientInfo("ApplicationName", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose), (int)255));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return db2Connection;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.userCache.clearCache();
        this.groupCache.clearCache();
        this.roleCache.clearCache();
        this.variableCache.clearCache();
        this.tablespaceCache.clearCache();
        this.storagegroupCache.clearCache();
        this.bufferpoolCache.clearCache();
        this.schemaCache.clearCache();
        this.dataTypeCache.clearCache();
        this.remoteServerCache.clearCache();
        this.wrapperCache.clearCache();
        this.userMappingCache.clearCache();
        this.listDBMParameters = null;
        this.listDBParameters = null;
        this.initialize(monitor);
        return this;
    }

    public Collection<DB2DataType> getLocalDataTypes() {
        try {
            return this.getDataTypes((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            LOG.error((Object)"DBException occurred when reading system dataTypes: ", (Throwable)e);
            return null;
        }
    }

    public DB2DataType getLocalDataType(String typeName) {
        try {
            return this.getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeName);
        }
        catch (DBException e) {
            LOG.error((Object)("DBException occurred when reading system dataTYpe : " + typeName), (Throwable)e);
            return null;
        }
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public Class<? extends DB2Schema> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DB2Schema.class;
    }

    public Collection<DB2Schema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public DB2Schema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    public DB2Schema getDefaultObject() {
        return this.activeSchemaName == null ? null : (DB2Schema)this.schemaCache.getCachedObject(this.activeSchemaName);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        DB2Schema oldSelectedEntity = this.getDefaultObject();
        if (!(object instanceof DB2Schema)) {
            throw new IllegalArgumentException("Invalid object type: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.setCurrentSchema(monitor, context, (DB2Schema)object);
            ++n2;
        }
        this.activeSchemaName = object.getName();
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        if (this.activeSchemaName != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        try {
            DB2Schema newSchema;
            String newSchemaName = this.determineActiveSchema((JDBCSession)session);
            if (!CommonUtils.equalObjects((Object)newSchemaName, (Object)this.activeSchemaName) && (newSchema = (DB2Schema)this.schemaCache.getCachedObject(newSchemaName)) != null) {
                this.setDefaultObject(session.getProgressMonitor(), newSchema);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this);
        }
    }

    private void setCurrentSchema(DBRProgressMonitor monitor, JDBCExecutionContext executionContext, DB2Schema object) throws DBCException {
        if (object == null) {
            LOG.debug((Object)"Null current schema");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                JDBCUtils.executeSQL((Connection)session, (String)String.format(SET_CURRENT_SCHEMA, object.getName()), (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBCException {
        String ptSchemaname = this.getExplainTablesSchemaName(session);
        if (ptSchemaname == null) {
            throw new DBCException(DB2Messages.dialog_explain_no_tables_found_ex);
        }
        DB2PlanAnalyser plan = new DB2PlanAnalyser(query, ptSchemaname);
        plan.explain((JDBCSession)session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    private String getExplainTablesSchemaName(DBCSession session) throws DBCException {
        String tablespaceName;
        String sessionUserSchema;
        block10: {
            List<String> listTablespaces;
            block9: {
                DBRProgressMonitor monitor = session.getProgressMonitor();
                try {
                    sessionUserSchema = JDBCUtils.queryString((JDBCSession)((JDBCSession)session), (String)GET_SESSION_USER, (Object[])new Object[0]).trim();
                }
                catch (SQLException e) {
                    throw new DBCException(e, session.getDataSource());
                }
                Boolean ok = DB2Utils.checkExplainTables(monitor, this, sessionUserSchema);
                if (ok.booleanValue()) {
                    LOG.debug((Object)("Valid explain tables found in " + sessionUserSchema));
                    this.schemaForExplainTables = sessionUserSchema;
                    return this.schemaForExplainTables;
                }
                ok = DB2Utils.checkExplainTables(monitor, this, "SYSTOOLS");
                if (ok.booleanValue()) {
                    LOG.debug((Object)"Valid explain tables found in SYSTOOLS");
                    this.schemaForExplainTables = "SYSTOOLS";
                    return this.schemaForExplainTables;
                }
                String msg = String.format(DB2Messages.dialog_explain_ask_to_create, sessionUserSchema);
                if (!UIUtils.confirmAction((String)DB2Messages.dialog_explain_no_tables, (String)msg)) {
                    return null;
                }
                try {
                    listTablespaces = DB2Utils.getListOfUsableTsForExplain(monitor, (JDBCSession)session);
                    if (!listTablespaces.isEmpty()) break block9;
                    DBUserInterface.getInstance().showError(DB2Messages.dialog_explain_no_tablespace_found_title, DB2Messages.dialog_explain_no_tablespace_found_title);
                    return null;
                }
                catch (SQLException e) {
                    throw new DBCException(e, session.getDataSource());
                }
            }
            tablespaceName = (String)new UITask<String>(){

                protected String runTask() {
                    DB2TablespaceChooser tsChooserDialog = new DB2TablespaceChooser(DBeaverUI.getActiveWorkbenchShell(), listTablespaces);
                    if (tsChooserDialog.open() == 0) {
                        return tsChooserDialog.getSelectedTablespace();
                    }
                    return null;
                }
            }.execute();
            if (tablespaceName != null) break block10;
            return null;
        }
        DB2Utils.createExplainTables(session.getProgressMonitor(), this, sessionUserSchema, tablespaceName);
        this.schemaForExplainTables = sessionUserSchema;
        return sessionUserSchema;
    }

    @Association
    public Collection<DB2Schema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Schema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Schema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2DataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2DataType getDataType(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2DataType)this.dataTypeCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Tablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Tablespace getTablespace(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Tablespace)this.tablespaceCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2StorageGroup> getStorageGroups(DBRProgressMonitor monitor) throws DBException {
        return this.storagegroupCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2StorageGroup getStorageGroup(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2StorageGroup)this.storagegroupCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Bufferpool> getBufferpools(DBRProgressMonitor monitor) throws DBException {
        return this.bufferpoolCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Bufferpool getBufferpool(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Bufferpool)this.bufferpoolCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Wrapper> getWrappers(DBRProgressMonitor monitor) throws DBException {
        return this.wrapperCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Wrapper getWrapper(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Wrapper)this.wrapperCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2UserMapping> getUserMappings(DBRProgressMonitor monitor) throws DBException {
        return this.userMappingCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2UserMapping getUserMapping(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2UserMapping)this.userMappingCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2RemoteServer> getRemoteServers(DBRProgressMonitor monitor) throws DBException {
        return this.remoteServerCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2RemoteServer getRemoteServer(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2RemoteServer)this.remoteServerCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Grantee> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Grantee getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Grantee)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Grantee> getGroups(DBRProgressMonitor monitor) throws DBException {
        return this.groupCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Grantee getGroup(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Grantee)this.groupCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Role> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Role getRole(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Role)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Variable> getVariables(DBRProgressMonitor monitor) throws DBException {
        return this.variableCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Variable getVariable(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Variable)this.variableCache.getObject(monitor, (DBSObject)this, name);
    }

    public List<DB2Parameter> getDbParameters(DBRProgressMonitor monitor) throws DBException {
        if (this.listDBParameters == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Database Parameters");){
                    this.listDBParameters = DB2Utils.readDBCfg(monitor, session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)e);
            }
        }
        return this.listDBParameters;
    }

    public List<DB2Parameter> getDbmParameters(DBRProgressMonitor monitor) throws DBException {
        if (this.listDBMParameters == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Instance Parameters");){
                    this.listDBMParameters = DB2Utils.readDBMCfg(monitor, session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)e);
            }
        }
        return this.listDBMParameters;
    }

    public List<DB2XMLString> getXmlStrings(DBRProgressMonitor monitor) throws DBException {
        if (this.listXMLStrings == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Global XMLStrings");){
                    this.listXMLStrings = DB2Utils.readXMLStrings(monitor, session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)e);
            }
        }
        return this.listXMLStrings;
    }

    public boolean isAuthorisedForApplications() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForApplications() != false;
    }

    public boolean isAuthorisedForContainers() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForContainers() != false;
    }

    public boolean isAuthorisedForDBCFG() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForDBCFG() != false;
    }

    public boolean isAuthorisedForAdminister() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForAdminister() != false;
    }

    public boolean isAtLeastV9_5() {
        return this.version >= DB2Constants.DB2v9_5;
    }

    public boolean isAtLeastV9_7() {
        return this.version >= DB2Constants.DB2v9_7;
    }

    public boolean isAtLeastV10_1() {
        return this.version >= DB2Constants.DB2v10_1;
    }

    public boolean isAtLeastV10_5() {
        return this.version >= DB2Constants.DB2v10_5;
    }

    public boolean isAtLeastV11_1() {
        return this.version >= DB2Constants.DB2v11_1;
    }

    public Double getVersion() {
        return this.version;
    }

    public DBSObjectCache<DB2DataSource, DB2Bufferpool> getBufferpoolCache() {
        return this.bufferpoolCache;
    }

    public DBSObjectCache<DB2DataSource, DB2RemoteServer> getRemoteServerCache() {
        return this.remoteServerCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Schema> getSchemaCache() {
        return this.schemaCache;
    }

    public DBSObjectCache<DB2DataSource, DB2DataType> getDataTypeCache() {
        return this.dataTypeCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Tablespace> getTablespaceCache() {
        return this.tablespaceCache;
    }

    public DBSObjectCache<DB2DataSource, DB2StorageGroup> getStorageGroupCache() {
        return this.storagegroupCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Variable> getVariableCache() {
        return this.variableCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Role> getRoleCache() {
        return this.roleCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Wrapper> getWrapperCache() {
        return this.wrapperCache;
    }
}

