/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.File;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreScriptExecuteWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreWizardPageSettings;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreScriptExecuteWizardPageSettings
extends PostgreWizardPageSettings<PostgreScriptExecuteWizard> {
    private Text inputFileText;

    public PostgreScriptExecuteWizardPageSettings(PostgreScriptExecuteWizard wizard) {
        super(wizard, wizard.isImport() ? PostgreMessages.tool_script_title_import : PostgreMessages.tool_script_title_execute);
        this.setTitle(wizard.isImport() ? PostgreMessages.tool_script_title_import : PostgreMessages.tool_script_title_execute);
        this.setDescription(wizard.isImport() ? PostgreMessages.tool_script_description_import : PostgreMessages.tool_script_description_execute);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && ((PostgreScriptExecuteWizard)this.wizard).getInputFile() != null;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group inputGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.tool_script_label_input, (int)3, (int)768, (int)0);
        this.inputFileText = UIUtils.createLabelText((Composite)inputGroup, (String)PostgreMessages.tool_script_label_input_file, (String)"", (int)2056);
        this.inputFileText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PostgreScriptExecuteWizardPageSettings.this.chooseInputFile();
            }
        });
        Button browseButton = new Button((Composite)inputGroup, 8);
        browseButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreScriptExecuteWizardPageSettings.this.chooseInputFile();
            }
        });
        if (((PostgreScriptExecuteWizard)this.wizard).getInputFile() != null) {
            this.inputFileText.setText(((PostgreScriptExecuteWizard)this.wizard).getInputFile().getName());
        }
        this.createSecurityGroup(composite);
        this.setControl((Control)composite);
    }

    private void chooseInputFile() {
        File file = DialogUtils.openFile((Shell)this.getShell(), (String[])new String[]{"*.sql", "*.txt", "*.*"});
        if (file != null) {
            this.inputFileText.setText(file.getAbsolutePath());
        }
        this.updateState();
    }

    private void updateState() {
        String fileName = this.inputFileText.getText();
        ((PostgreScriptExecuteWizard)this.wizard).setInputFile(CommonUtils.isEmpty((String)fileName) ? null : new File(fileName));
        this.getContainer().updateButtons();
    }
}

