/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreWizardPageSettings;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizardPageObjects
extends PostgreWizardPageSettings<PostgreBackupWizard> {
    private static final Log log = Log.getLog(PostgreBackupWizardPageObjects.class);
    private Table schemasTable;
    private Table tablesTable;
    private Map<PostgreSchema, Set<PostgreTableBase>> checkedObjects = new HashMap<PostgreSchema, Set<PostgreTableBase>>();
    private PostgreSchema curSchema;
    private PostgreDataSource dataSource;

    PostgreBackupWizardPageObjects(PostgreBackupWizard wizard) {
        super(wizard, PostgreMessages.wizard_backup_page_object_title_schema_table);
        this.setTitle(PostgreMessages.wizard_backup_page_object_title);
        this.setDescription(PostgreMessages.wizard_backup_page_object_description);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group objectsGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_page_object_group_object, (int)1, (int)768, (int)0);
        objectsGroup.setLayoutData((Object)new GridData(1808));
        CustomSashForm sash = new CustomSashForm((Composite)objectsGroup, 512);
        sash.setLayoutData((Object)new GridData(1808));
        Composite catPanel = UIUtils.createPlaceholder((Composite)sash, (int)1);
        catPanel.setLayoutData((Object)new GridData(1808));
        this.schemasTable = new Table(catPanel, 2080);
        this.schemasTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                PostgreSchema catalog = (PostgreSchema)item.getData();
                if (event.detail == 32) {
                    PostgreBackupWizardPageObjects.this.schemasTable.select(PostgreBackupWizardPageObjects.this.schemasTable.indexOf(item));
                    PostgreBackupWizardPageObjects.this.checkedObjects.remove(catalog);
                }
                PostgreBackupWizardPageObjects.this.loadTables(catalog);
                PostgreBackupWizardPageObjects.this.updateState();
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        this.schemasTable.setLayoutData((Object)gd);
        Composite buttonsPanel = UIUtils.createPlaceholder((Composite)catPanel, (int)3, (int)5);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        new Label(buttonsPanel, 0).setLayoutData((Object)new GridData(512));
        PostgreBackupWizardPageObjects.createCheckButtons((Composite)buttonsPanel, (Table)this.schemasTable);
        Composite tablesPanel = UIUtils.createPlaceholder((Composite)sash, (int)1);
        tablesPanel.setLayoutData((Object)new GridData(1808));
        this.tablesTable = new Table(tablesPanel, 2080);
        GridData gd2 = new GridData(1808);
        gd2.heightHint = 50;
        this.tablesTable.setLayoutData((Object)gd2);
        this.tablesTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    PostgreBackupWizardPageObjects.this.updateCheckedTables();
                    PostgreBackupWizardPageObjects.this.updateState();
                }
            }
        });
        Composite buttonsPanel2 = UIUtils.createPlaceholder((Composite)tablesPanel, (int)3, (int)5);
        buttonsPanel2.setLayoutData((Object)new GridData(768));
        final Button exportViewsCheck = UIUtils.createCheckbox((Composite)buttonsPanel2, (String)PostgreMessages.wizard_backup_page_object_checkbox_show_view, (boolean)false);
        exportViewsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PostgreBackupWizard)((PostgreBackupWizardPageObjects)PostgreBackupWizardPageObjects.this).wizard).showViews = exportViewsCheck.getSelection();
                PostgreBackupWizardPageObjects.this.loadTables(null);
            }
        });
        exportViewsCheck.setLayoutData((Object)new GridData(512));
        PostgreBackupWizardPageObjects.createCheckButtons((Composite)buttonsPanel2, (Table)this.tablesTable);
        this.dataSource = null;
        LinkedHashSet<PostgreSchema> activeCatalogs = new LinkedHashSet<PostgreSchema>();
        for (DBSObject object : ((PostgreBackupWizard)this.wizard).getDatabaseObjects()) {
            if (object instanceof PostgreSchema) {
                activeCatalogs.add((PostgreSchema)object);
                this.dataSource = ((PostgreSchema)object).getDataSource();
                continue;
            }
            if (object instanceof PostgreTableBase) {
                PostgreSchema catalog = (PostgreSchema)((PostgreTableBase)object).getContainer();
                this.dataSource = catalog.getDataSource();
                activeCatalogs.add(catalog);
                Set<PostgreTableBase> tables = this.checkedObjects.get(catalog);
                if (tables == null) {
                    tables = new HashSet<PostgreTableBase>();
                    this.checkedObjects.put(catalog, tables);
                }
                tables.add((PostgreTableBase)object);
                if (!((PostgreTableBase)object).isView()) continue;
                ((PostgreBackupWizard)this.wizard).showViews = true;
                exportViewsCheck.setSelection(true);
                continue;
            }
            if (!(object.getDataSource() instanceof PostgreDataSource)) continue;
            this.dataSource = (PostgreDataSource)object.getDataSource();
        }
        if (this.dataSource != null) {
            boolean tablesLoaded = false;
            try {
                for (PostgreSchema schema : this.dataSource.getDefaultInstance().getSchemas((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (schema.isSystem() || schema.isUtility()) continue;
                    TableItem item = new TableItem(this.schemasTable, 0);
                    item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
                    item.setText(0, schema.getName());
                    item.setData((Object)schema);
                    if (!activeCatalogs.contains(schema)) continue;
                    item.setChecked(true);
                    this.schemasTable.select(this.schemasTable.indexOf(item));
                    if (tablesLoaded) continue;
                    this.loadTables(schema);
                    tablesLoaded = true;
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        this.updateState();
        this.setControl((Control)composite);
    }

    private void updateCheckedTables() {
        TableItem[] tableItems;
        HashSet<PostgreTableBase> checkedTables = new HashSet<PostgreTableBase>();
        TableItem[] tableItemArray = tableItems = this.tablesTable.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                checkedTables.add((PostgreTableBase)item.getData());
            }
            ++n2;
        }
        TableItem catalogItem = this.schemasTable.getItem(this.schemasTable.getSelectionIndex());
        catalogItem.setChecked(!checkedTables.isEmpty());
        if (checkedTables.isEmpty() || checkedTables.size() == tableItems.length) {
            this.checkedObjects.remove(this.curSchema);
        } else {
            this.checkedObjects.put(this.curSchema, checkedTables);
        }
    }

    private boolean isChecked(PostgreSchema catalog) {
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == catalog) {
                return item.getChecked();
            }
            ++n2;
        }
        return false;
    }

    private void loadTables(PostgreSchema catalog) {
        if (catalog != null) {
            this.curSchema = catalog;
        }
        if (this.curSchema == null) {
            return;
        }
        final boolean isCatalogChecked = this.isChecked(this.curSchema);
        final Set<PostgreTableBase> checkedObjects = this.checkedObjects.get(this.curSchema);
        new AbstractJob("Load '" + this.curSchema.getName() + "' tables"){
            {
                super($anonymous0);
                this.setUser(true);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    final ArrayList<PostgreTableReal> objects = new ArrayList<PostgreTableReal>();
                    objects.addAll(PostgreBackupWizardPageObjects.this.curSchema.getTables(monitor));
                    if (((PostgreBackupWizard)((PostgreBackupWizardPageObjects)PostgreBackupWizardPageObjects.this).wizard).showViews) {
                        objects.addAll(PostgreBackupWizardPageObjects.this.curSchema.getViews(monitor));
                    }
                    Collections.sort(objects, DBUtils.nameComparator());
                    DBeaverUI.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PostgreBackupWizardPageObjects.this.tablesTable.removeAll();
                            for (PostgreTableBase table : objects) {
                                TableItem item = new TableItem(PostgreBackupWizardPageObjects.this.tablesTable, 0);
                                item.setImage(DBeaverIcons.getImage((DBPImage)(table.isView() ? DBIcon.TREE_VIEW : DBIcon.TREE_TABLE)));
                                item.setText(0, table.getName());
                                item.setData((Object)table);
                                item.setChecked(isCatalogChecked && (checkedObjects == null || checkedObjects.contains(table)));
                            }
                        }
                    });
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Table list", "Can't read table list", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void saveState() {
        ((PostgreBackupWizard)this.wizard).objects.clear();
        ArrayList<PostgreSchema> schemas = new ArrayList<PostgreSchema>();
        ArrayList<PostgreTableBase> tables = new ArrayList<PostgreTableBase>();
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                PostgreSchema schema = (PostgreSchema)item.getData();
                Set<PostgreTableBase> checkedTables = this.checkedObjects.get(schema);
                if (CommonUtils.isEmpty(checkedTables)) {
                    schemas.add(schema);
                } else {
                    tables.addAll(checkedTables);
                }
            }
            ++n2;
        }
        PostgreDatabaseBackupInfo info = new PostgreDatabaseBackupInfo(this.dataSource.getDefaultInstance(), schemas, tables);
        ((PostgreBackupWizard)this.wizard).objects.add(info);
    }

    private void updateState() {
        boolean complete = false;
        if (!this.checkedObjects.isEmpty()) {
            complete = true;
        }
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                complete = true;
                break;
            }
            ++n2;
        }
        this.setPageComplete(complete);
    }
}

