/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableConstraintBase
extends JDBCTableConstraint<PostgreTableBase>
implements PostgreObject,
DBPScriptObject {
    private static final Log log = Log.getLog(PostgreTableConstraintBase.class);
    private long oid;
    private String constrDDL;

    public PostgreTableConstraintBase(PostgreTableBase table, String name, DBSEntityConstraintType constraintType, JDBCResultSet resultSet) throws DBException {
        super((JDBCTable)table, name, null, constraintType, true);
        this.oid = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"oid");
    }

    public PostgreTableConstraintBase(PostgreTableBase table, String constraintName, DBSEntityConstraintType constraintType) {
        super((JDBCTable)table, constraintName, null, constraintType, false);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((PostgreTableBase)this.getTable()).getContainer(), this.getTable(), this});
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)((PostgreTableBase)this.getTable()).getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreTableBase)this.getParentObject()).getDatabase();
    }

    @Override
    public long getObjectId() {
        return this.oid;
    }

    abstract void cacheAttributes(DBRProgressMonitor var1, List<? extends PostgreTableConstraintColumn> var2, boolean var3);

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.constrDDL == null && this.isPersisted()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read constraint definition");){
                    this.constrDDL = "CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)this) + " " + JDBCUtils.queryString((JDBCSession)session, (String)"SELECT pg_catalog.pg_get_constraintdef(?)", (Object[])new Object[]{this.getObjectId()});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        if (CommonUtils.getOption(options, (String)"embedded.source")) {
            return this.constrDDL;
        }
        return "ALTER TABLE " + ((PostgreTableBase)this.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + this.constrDDL;
    }
}

