/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public class PostgreSequence
extends PostgreTableBase
implements DBSSequence,
DBPQualifiedObject {
    private static final Log log = Log.getLog(PostgreSequence.class);
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public PostgreSequence(PostgreSchema schema, JDBCResultSet dbResult) {
        super(schema, (ResultSet)dbResult);
    }

    public PostgreSequence(PostgreSchema catalog) {
        super(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Load sequence additional info");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbSeqStat = session.prepareStatement("SELECT last_value,min_value,max_value,increment_by from " + this.getFullyQualifiedName(DBPEvaluationContext.DML));){
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet seqResults = dbSeqStat.executeQuery();){
                        if (seqResults.next()) {
                            this.additionalInfo.lastValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (int)1);
                            this.additionalInfo.minValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (int)2);
                            this.additionalInfo.maxValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (int)3);
                            this.additionalInfo.incrementBy = JDBCUtils.safeGetLong((ResultSet)seqResults, (int)4);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                this.additionalInfo.loaded = true;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence values", (Throwable)e);
        }
    }

    public Number getLastValue() {
        return this.additionalInfo.lastValue;
    }

    public Number getMinValue() {
        return this.additionalInfo.minValue;
    }

    public Number getMaxValue() {
        return this.additionalInfo.maxValue;
    }

    public Number getIncrementBy() {
        return this.additionalInfo.incrementBy;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.SEQUENCE;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        AdditionalInfo info = this.getAdditionalInfo(monitor);
        StringBuilder sql = new StringBuilder();
        sql.append("-- DROP SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
        sql.append("CREATE SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (info.getIncrementBy() != null && info.getIncrementBy().longValue() > 0L) {
            sql.append("\nINCREMENT BY ").append(info.getIncrementBy());
        }
        if (info.getMinValue() != null && info.getMinValue().longValue() > 0L) {
            sql.append("\nMINVALUE ").append(info.getMinValue());
        } else {
            sql.append("\nNO MINVALUE");
        }
        if (info.getMaxValue() != null && info.getMaxValue().longValue() > 0L) {
            sql.append("\nMAXVALUE ").append(info.getMaxValue());
        } else {
            sql.append("\nNO MAXVALUE");
        }
        if (info.getLastValue() != null && info.getLastValue().longValue() > 0L) {
            sql.append("\nSTART ").append(info.getLastValue());
        }
        return sql.toString();
    }

    public static class AdditionalInfo {
        private volatile boolean loaded = false;
        private Number lastValue;
        private Number minValue;
        private Number maxValue;
        private Number incrementBy;

        @Property(viewable=true, editable=true, updatable=true, order=10)
        public Number getLastValue() {
            return this.lastValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=11)
        public Number getMinValue() {
            return this.minValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=12)
        public Number getMaxValue() {
            return this.maxValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=13)
        public Number getIncrementBy() {
            return this.incrementBy;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<PostgreSequence> {
        public boolean isPropertyCached(PostgreSequence object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }
}

