/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreRolePermission
extends PostgrePermission {
    private static final Log log = Log.getLog(PostgreRolePermission.class);
    private String schemaName;
    private String tableName;

    public PostgreRolePermission(PostgrePermissionsOwner owner, String schemaName, String tableName, List<PostgrePrivilege> privileges) {
        super(owner, privileges);
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getFullTableName();
    }

    @Override
    public PostgreTableBase getTargetObject(DBRProgressMonitor monitor) throws DBException {
        PostgreSchema schema = this.owner.getDatabase().getSchema(monitor, this.schemaName);
        if (schema != null) {
            return schema.getChild(monitor, this.tableName);
        }
        return null;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullTableName() {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.schemaName)) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.tableName);
    }

    public String toString() {
        return this.getFullTableName();
    }

    @Override
    public int compareTo(@NotNull PostgrePermission o) {
        if (o instanceof PostgreRolePermission) {
            int res = this.schemaName.compareTo(((PostgreRolePermission)o).schemaName);
            return res != 0 ? res : this.tableName.compareTo(((PostgreRolePermission)o).tableName);
        }
        return 0;
    }
}

