/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class PostgreMaterializedView
extends PostgreViewBase {
    public PostgreMaterializedView(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreMaterializedView(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    public Collection<PostgreIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().indexCache.getObjects(monitor, this.getSchema(), this);
    }

    @Override
    protected String readExtraDefinition(JDBCSession session, Map<String, Object> options) throws DBException {
        Collection<PostgreIndex> indexes = this.getIndexes(session.getProgressMonitor());
        if (!CommonUtils.isEmpty(indexes)) {
            StringBuilder indexDefs = new StringBuilder("\n-- View indexes:\n");
            for (PostgreIndex index : indexes) {
                String indexDefinition = index.getObjectDefinitionText(session.getProgressMonitor(), options);
                indexDefs.append(indexDefinition).append(";\n");
            }
            return indexDefs.toString();
        }
        return null;
    }

    @Override
    public String getViewType() {
        return "MATERIALIZED VIEW";
    }
}

