/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttributeIdentity;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributeEditPage;
import org.jkiss.utils.CommonUtils;

public class PostgreTableColumnManager
extends SQLTableColumnManager<PostgreTableColumn, PostgreTableBase>
implements DBEObjectRenamer<PostgreTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDataTypeModifier = (column, sql, command) -> {
        PostgreDataType rawType;
        PostgreDataType dataType;
        block23: {
            sql.append(' ');
            dataType = column.getDataType();
            String defValue = column.getDefaultValue();
            if (CommonUtils.isEmpty((String)defValue) || !defValue.contains("nextval")) break block23;
            switch (dataType.getName()) {
                case "int2": {
                    sql.append("smallserial");
                    return;
                }
                case "int4": {
                    sql.append("serial");
                    return;
                }
                case "int8": {
                    sql.append("bigserial");
                    return;
                }
            }
        }
        if ((rawType = dataType.getElementType()) != null) {
            sql.append(rawType.getTypeName());
        } else {
            sql.append(dataType.getTypeName());
        }
        switch (dataType.getDataKind()) {
            case STRING: {
                long length = column.getMaxLength();
                if (length <= 0L) break;
                sql.append('(').append(length).append(')');
                break;
            }
            case NUMERIC: {
                if (dataType.getTypeID() != 2) break;
                int precision = CommonUtils.toInt((Object)column.getPrecision());
                int scale = CommonUtils.toInt((Object)column.getScale());
                if (scale <= 0 && precision <= 0) break;
                sql.append('(');
                if (precision > 0) {
                    sql.append(precision);
                }
                if (scale > 0) {
                    if (precision > 0) {
                        sql.append(',');
                    }
                    sql.append(scale);
                }
                sql.append(')');
            }
        }
        if (rawType != null) {
            sql.append("[]");
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDefaultModifier = (column, sql, command) -> {
        block11: {
            String defaultValue = column.getDefaultValue();
            if (CommonUtils.isEmpty((String)defaultValue) || !defaultValue.contains("nextval")) break block11;
            switch (column.getDataType().getName()) {
                case "int2": 
                case "int4": 
                case "int8": {
                    return;
                }
            }
        }
        this.DefaultModifier.appendModifier(column, sql, command);
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreIdentityModifier = (column, sql, command) -> {
        PostgreAttributeIdentity identity = column.getIdentity();
        if (identity != null) {
            sql.append(" ").append(identity.getDefinitionClause());
        }
    };

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableColumn> getObjectsCache(PostgreTableColumn object) {
        return ((PostgreSchema)((PostgreTableBase)object.getParentObject()).getContainer()).tableCache.getChildrenCache((PostgreTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(PostgreTableColumn column) {
        return new SQLTableColumnManager.ColumnModifier[]{this.PostgreDataTypeModifier, this.NullNotNullModifier, this.PostgreDefaultModifier, this.PostgreIdentityModifier};
    }

    public StringBuilder getNestedDeclaration(PostgreTableBase owner, DBECommandAbstract<PostgreTableColumn> command, Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration((JDBCTable)owner, command, options);
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        return decl;
    }

    protected PostgreTableColumn createDatabaseObject(final DBRProgressMonitor monitor, final DBECommandContext context, final PostgreTableBase parent, Object copyFrom) {
        return (PostgreTableColumn)((Object)new UITask<PostgreTableColumn>(){

            protected PostgreTableColumn runTask() {
                PostgreTableColumn column = new PostgreTableColumn(parent);
                column.setName(PostgreTableColumnManager.this.getNewColumnName(monitor, context, parent));
                PostgreDataType dataType = parent.getDatabase().getDataType(1043L);
                column.setDataType(dataType);
                column.setOrdinalPosition(-1);
                AttributeEditPage page = new AttributeEditPage(null, (DBSEntityAttribute)column);
                if (!page.edit()) {
                    return null;
                }
                return column;
            }
        }.execute());
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        if (column.getDataType() != null) {
            typeClause = String.valueOf(typeClause) + " USING " + DBUtils.getQuotedIdentifier((DBSObject)column) + "::" + column.getDataType().getName();
        }
        if (command.getProperty((Object)"dataType") != null || command.getProperty((Object)"maxLength") != null || command.getProperty((Object)"precision") != null || command.getProperty((Object)"scale") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column type", String.valueOf(prefix) + "TYPE " + typeClause));
        }
        if (command.getProperty((Object)"required") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column nullability", String.valueOf(prefix) + (column.isRequired() ? "SET" : "DROP") + " NOT NULL"));
        }
        if (command.getProperty((Object)"defaultValue") != null) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop column default", String.valueOf(prefix) + "DROP DEFAULT"));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column default", String.valueOf(prefix) + "SET DEFAULT " + column.getDefaultValue()));
            }
        }
        if (command.getProperty((Object)"description") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
        }
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
        PostgreTableBase table = (PostgreTableBase)object.getTable();
        if (table.isPersisted() && table instanceof PostgreViewBase) {
            table.setObjectDefinitionText(null);
            commandContext.addCommand((DBECommand)new SQLObjectEditor.EmptyCommand((DBPObject)table), (DBECommandReflector)new SQLObjectEditor.RefreshObjectReflector(), true);
        }
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }
}

