/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedureParameter;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSourceObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class MySQLProcedure
extends AbstractProcedure<MySQLDataSource, MySQLCatalog>
implements MySQLSourceObject,
DBPRefreshableObject {
    private DBSProcedureType procedureType;
    private String resultType;
    private String bodyType;
    private boolean deterministic;
    private transient String clientBody;
    private String charset;

    public MySQLProcedure(MySQLCatalog catalog) {
        super((DBSObjectContainer)catalog, false);
        this.procedureType = DBSProcedureType.PROCEDURE;
        this.bodyType = "SQL";
        this.resultType = "";
        this.deterministic = false;
    }

    public MySQLProcedure(MySQLCatalog catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, true);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) {
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_NAME"));
        this.setDescription(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_COMMENT"));
        String procType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_TYPE");
        this.procedureType = procType == null ? DBSProcedureType.PROCEDURE : DBSProcedureType.valueOf((String)procType.toUpperCase(Locale.ENGLISH));
        this.resultType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DTD_IDENTIFIER");
        this.bodyType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_BODY");
        this.charset = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARACTER_SET_CLIENT");
        this.deterministic = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_DETERMINISTIC", (String)"YES");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_COMMENT");
    }

    @Property(order=2)
    public DBSProcedureType getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(DBSProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    @Property(order=2)
    public String getResultType() {
        return this.resultType;
    }

    @Property(order=3)
    public String getBodyType() {
        return this.bodyType;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getDeclaration(DBRProgressMonitor monitor) throws DBException {
        if (this.clientBody == null) {
            if (!this.persisted) {
                this.clientBody = "CREATE " + this.getProcedureType().name() + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "()" + GeneralUtils.getDefaultLineSeparator() + (this.procedureType == DBSProcedureType.FUNCTION ? "RETURNS INT" + GeneralUtils.getDefaultLineSeparator() : "") + "BEGIN" + GeneralUtils.getDefaultLineSeparator() + "END";
            } else {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read procedure declaration");){
                        Throwable throwable2 = null;
                        Object var6_10 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW CREATE " + this.getProcedureType().name() + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));){
                            Throwable throwable3 = null;
                            Object var9_15 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                if (dbResult.next()) {
                                    this.clientBody = JDBCUtils.safeGetString((ResultSet)dbResult, (String)(this.getProcedureType() == DBSProcedureType.PROCEDURE ? "Create Procedure" : "Create Function"));
                                    this.clientBody = this.clientBody == null ? "" : this.normalizeCreateStatement(this.clientBody);
                                } else {
                                    this.clientBody = "";
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    this.clientBody = e.getMessage();
                    throw new DBException((Throwable)e, this.getDataSource());
                }
            }
        }
        return this.clientBody;
    }

    private String normalizeCreateStatement(String createDDL) {
        String procType = this.getProcedureType().name();
        int divPos = createDDL.indexOf(String.valueOf(procType) + " `");
        if (divPos != -1) {
            return String.valueOf(createDDL.substring(0, divPos)) + procType + " `" + ((MySQLCatalog)this.getContainer()).getName() + "`." + createDDL.substring(divPos + procType.length() + 1);
        }
        return createDDL;
    }

    @Property(editable=true, updatable=true, order=3)
    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    private static void appendParameterType(StringBuilder cb, MySQLProcedureParameter column) {
        cb.append(column.getTypeName());
        if (column.getDataKind() == DBPDataKind.STRING && column.getMaxLength() > 0L) {
            cb.append('(').append(column.getMaxLength()).append(')');
        }
    }

    public String getDeclaration() {
        return this.clientBody;
    }

    public void setDeclaration(String clientBody) {
        this.clientBody = clientBody;
    }

    public String getCharset() {
        return this.charset;
    }

    public Collection<MySQLProcedureParameter> getParameters(DBRProgressMonitor monitor) throws DBException {
        return ((MySQLCatalog)this.getContainer()).proceduresCache.getChildren(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDeclaration(monitor);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.setDeclaration(sourceText);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((MySQLCatalog)this.getContainer()).proceduresCache.refreshObject(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
    }

    public String toString() {
        return String.valueOf(this.procedureType.name()) + " " + this.getName();
    }
}

