/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLInformation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSourceObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MySQLEvent
extends MySQLInformation
implements MySQLSourceObject {
    private static final String CAT_MAIN = "Main";
    private static final String CAT_DETAILS = "Details";
    private static final String CAT_STATS = "Statistics";
    private String name;
    private String definer;
    private String timeZone;
    private String eventBody;
    private String eventDefinition;
    private String eventType;
    private Date executeAt;
    private String intervalValue;
    private String intervalField;
    private String sqlMode;
    private Date starts;
    private Date ends;
    private String status;
    private String onCompletion;
    private Date created;
    private Date lastAltered;
    private Date lastExecuted;
    private String eventComment;
    private long originator;
    private MySQLCharset characterSetClient;
    private MySQLCollation collationConnection;
    private MySQLCollation databaseCollation;

    public MySQLEvent(MySQLCatalog catalog, ResultSet dbResult) throws SQLException {
        super(catalog.getDataSource());
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_NAME");
        this.definer = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFINER");
        this.timeZone = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TIME_ZONE");
        this.eventBody = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_BODY");
        this.eventDefinition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_DEFINITION");
        this.eventType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_TYPE");
        this.executeAt = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"EXECUTE_AT");
        this.intervalValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTERVAL_VALUE");
        this.intervalField = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTERVAL_FIELD");
        this.sqlMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_MODE");
        this.starts = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STARTS");
        this.ends = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ENDS");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS");
        this.onCompletion = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ON_COMPLETION");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
        this.lastExecuted = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_EXECUTED");
        this.eventComment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_COMMENT");
        this.originator = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ORIGINATOR");
        this.characterSetClient = this.getDataSource().getCharset(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARACTER_SET_CLIENT"));
        this.collationConnection = this.getDataSource().getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATION_CONNECTION"));
        this.databaseCollation = this.getDataSource().getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATABASE_COLLATION"));
    }

    @Property(viewable=true, category="Main", order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, category="Details", order=100)
    @Nullable
    public String getDescription() {
        return this.eventComment;
    }

    @Property(viewable=true, category="Main", order=10)
    public String getEventType() {
        return this.eventType;
    }

    @Property(viewable=true, category="Main", order=11)
    public Date getExecuteAt() {
        return this.executeAt;
    }

    @Property(viewable=true, category="Main", order=12)
    public String getIntervalValue() {
        return this.intervalValue;
    }

    @Property(viewable=true, category="Main", order=13)
    public String getIntervalField() {
        return this.intervalField;
    }

    @Property(viewable=true, category="Details", order=14)
    public String getEventBody() {
        return this.eventBody;
    }

    @Property(category="Details", order=30)
    public String getDefiner() {
        return this.definer;
    }

    @Property(category="Details", order=31)
    public String getTimeZone() {
        return this.timeZone;
    }

    @Property(category="Details", order=32)
    public String getSqlMode() {
        return this.sqlMode;
    }

    @Property(category="Details", order=33)
    public Date getStarts() {
        return this.starts;
    }

    @Property(category="Details", order=34)
    public Date getEnds() {
        return this.ends;
    }

    @Property(category="Statistics", order=35)
    public String getStatus() {
        return this.status;
    }

    @Property(category="Details", order=36)
    public String getOnCompletion() {
        return this.onCompletion;
    }

    @Property(category="Statistics", order=37)
    public Date getCreated() {
        return this.created;
    }

    @Property(category="Statistics", order=38)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(category="Statistics", order=39)
    public Date getLastExecuted() {
        return this.lastExecuted;
    }

    @Property(category="Details", order=40)
    public long getOriginator() {
        return this.originator;
    }

    @Property(category="Details", order=41)
    public MySQLCharset getCharacterSetClient() {
        return this.characterSetClient;
    }

    @Property(category="Details", order=42)
    public MySQLCollation getCollationConnection() {
        return this.collationConnection;
    }

    @Property(category="Details", order=43)
    public MySQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.eventDefinition;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.eventDefinition = sourceText;
    }
}

