/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.editors;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSession;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSessionManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.utils.CommonUtils;

public class MySQLSessionEditor
extends AbstractSessionEditor {
    private static final Log log = Log.getLog(MySQLSessionEditor.class);
    private KillSessionAction killSessionAction;
    private KillSessionAction terminateQueryAction;

    public void createEditorControl(Composite parent) {
        this.killSessionAction = new KillSessionAction(false);
        this.terminateQueryAction = new KillSessionAction(true);
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<MySQLSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new MySQLSessionManager((MySQLDataSource)executionContext.getDataSource())){
            private boolean hideSleeping;

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)MySQLSessionEditor.this.killSessionAction);
                contributionManager.add((IAction)MySQLSessionEditor.this.terminateQueryAction);
                contributionManager.add((IContributionItem)new Separator());
                contributionManager.add((IContributionItem)new ControlContribution("MySQLSessionHideSleep"){

                    protected Control createControl(Composite parent) {
                        final Button hideSleepingCheck = UIUtils.createCheckbox((Composite)parent, (String)"Hide sleeping", (String)"Show only active connections", (boolean)hideSleeping, (int)0);
                        hideSleepingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                hideSleeping = hideSleepingCheck.getSelection();
                                MySQLSessionEditor.this.refreshPart((Object)MySQLSessionEditor.this, true);
                            }
                        });
                        return hideSleepingCheck;
                    }
                });
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                MySQLSessionEditor.this.killSessionAction.setEnabled(session != null);
                MySQLSessionEditor.this.terminateQueryAction.setEnabled(session != null && !CommonUtils.isEmpty((String)session.getActiveQuery()));
            }

            public Map<String, Object> getSessionOptions() {
                if (this.hideSleeping) {
                    return Collections.singletonMap("hideSleeping", true);
                }
                return super.getSessionOptions();
            }
        };
    }

    private class KillSessionAction
    extends Action {
        private boolean killQuery;

        public KillSessionAction(boolean killQuery) {
            super(killQuery ? MySQLMessages.editors_session_editor_action_terminate_Query : MySQLMessages.editors_session_editor_action_kill_Session, killQuery ? UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP") : DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_DISCONNECT));
            this.killQuery = killQuery;
        }

        public void run() {
            DBAServerSession session = MySQLSessionEditor.this.getSessionsViewer().getSelectedSession();
            if (session != null && UIUtils.confirmAction((Shell)MySQLSessionEditor.this.getSite().getShell(), (String)this.getText(), (String)NLS.bind((String)MySQLMessages.editors_session_editor_confirm, (Object)this.getText(), (Object)session))) {
                MySQLSessionEditor.this.getSessionsViewer().alterSession(MySQLSessionEditor.this.getSessionsViewer().getSelectedSession(), Collections.singletonMap("killQuery", this.killQuery));
            }
        }
    }
}

