/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.redis.model;

import com.dbeaver.ent.redis.RedisUtils;
import com.dbeaver.ent.redis.exec.RedisSession;
import com.dbeaver.ent.redis.model.RedisDataSource;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class RedisDataSourceInfo
implements DBPDataSourceInfo {
    private static final Log log = Log.getLog(RedisDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "redis.clients.jedis";
    private final RedisDataSource dataSource;

    public RedisDataSourceInfo(RedisDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isReadOnlyData() {
        return false;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "Redis";
    }

    public String getDatabaseProductVersion() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)this.dataSource, (String)"Read Redis server info");){
            String serverInfo = session.getJedis().info("server");
            Map<String, String> infoMap = RedisUtils.parseInfo(serverInfo);
            return String.valueOf(infoMap.get("redis_version")) + " (" + infoMap.get("redis_mode") + ")" + "\n" + infoMap.get("os");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Jedis driver bundle 'redis.clients.jedis' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return false;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public boolean supportsResultSetLimit() {
        return false;
    }

    public boolean supportsResultSetScroll() {
        return false;
    }

    public boolean isDynamicMetadata() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return false;
    }
}

