/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.redis.exec;

import com.dbeaver.ent.redis.exec.RedisBaseResultSet;
import com.dbeaver.ent.redis.exec.RedisBaseStatement;
import com.dbeaver.ent.redis.exec.RedisResultSetCursor;
import com.dbeaver.ent.redis.exec.RedisResultSetList;
import com.dbeaver.ent.redis.exec.RedisResultSetSimple;
import com.dbeaver.ent.redis.exec.RedisSession;
import com.dbeaver.ent.redis.model.RedisKeyType;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.Jedis;

public class RedisKeyStatement
extends RedisBaseStatement {
    private static final Log log = Log.getLog(RedisKeyStatement.class);
    @NotNull
    private final RedisKeyType keyType;
    @NotNull
    private final String keyName;
    private RedisBaseResultSet resultSet;

    public RedisKeyStatement(@NotNull RedisSession session, @NotNull String key, @NotNull RedisKeyType keyType, long firstRow, long maxRows) {
        super(session, "SELECT * FROM " + key, firstRow, maxRows);
        this.keyName = key;
        this.keyType = keyType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeStatement() throws DBCException {
        QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        Jedis jedis = this.session.getJedis();
        try {
            switch (this.keyType) {
                case string: {
                    this.resultSet = new RedisResultSetSimple(this, jedis.get(this.keyName), this.offset);
                    return true;
                }
                case set: 
                case zset: 
                case hash: {
                    this.resultSet = new RedisResultSetCursor(this, this.keyName, this.keyType);
                    return true;
                }
                case list: {
                    this.resultSet = new RedisResultSetList(this, this.keyName);
                    return true;
                }
                default: {
                    throw new DBCException("Unsupported key type: " + (Object)((Object)this.keyType));
                }
            }
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.resultSet == null) {
            throw new DBCException("Can't open Redis key result set before execute");
        }
        return this.resultSet;
    }
}

