/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.redis.exec;

import com.dbeaver.ent.redis.exec.RedisBaseStatement;
import com.dbeaver.ent.redis.exec.RedisSession;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.qm.QMUtils;

public abstract class RedisBaseResultSet
implements DBCResultSet {
    private static final Log log = Log.getLog(RedisBaseResultSet.class);
    protected final RedisBaseStatement statement;
    protected MetaData metaData;
    protected int rowNumber = -1;

    public RedisBaseResultSet(RedisBaseStatement statement) {
        this.statement = statement;
        QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
    }

    public RedisSession getSession() {
        return this.statement.getSession();
    }

    public RedisBaseStatement getSourceStatement() {
        return this.statement;
    }

    public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    @NotNull
    public MetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new MetaData();
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public void close() {
        QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.rowNumber);
    }

    protected void fillMetaData(List<DBCAttributeMetaData> attribute) {
    }

    private class MetaData
    implements DBCResultSetMetaData {
        public List<DBCAttributeMetaData> getAttributes() {
            ArrayList<DBCAttributeMetaData> attrs = new ArrayList<DBCAttributeMetaData>(1);
            RedisBaseResultSet.this.fillMetaData(attrs);
            return attrs;
        }
    }

    public class OutputAttribute
    implements DBCAttributeMetaData {
        private final String name;
        private final int position;
        private final int typeId;
        private final DBPDataKind dataKind;

        public OutputAttribute(String name, int position, int typeId, DBPDataKind dataKind) {
            this.name = name;
            this.position = position;
            this.typeId = typeId;
            this.dataKind = dataKind;
        }

        public String getTypeName() {
            return this.dataKind.name();
        }

        public String getFullTypeName() {
            return this.getTypeName();
        }

        public int getTypeID() {
            return this.typeId;
        }

        public DBPDataKind getDataKind() {
            return this.dataKind;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Object getSource() {
            return null;
        }

        @NotNull
        public String getLabel() {
            return this.name;
        }

        public String getEntityName() {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return null;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

