/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.json;

import com.dbeaver.ee.runtime.internal.ui.resultset.ResultsetMessages;
import com.dbeaver.ee.runtime.ui.editors.json.JSONTextEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.stream.AbstractTextPanelEditor;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class JSONPanelEditor
extends AbstractTextPanelEditor {
    private IValueController valueController;
    private IEditorSite subSite;
    private JSONTextEditor editor;

    public StyledText createControl(IValueController iValueController) {
        this.valueController = iValueController;
        this.subSite = new SubEditorSite(iValueController.getValueSite());
        this.editor = new JSONTextEditor();
        try {
            this.editor.init(this.subSite, StringEditorInput.EMPTY_INPUT);
        }
        catch (PartInitException partInitException) {
            iValueController.showMessage(partInitException.getMessage(), DBPMessageType.ERROR);
            return new StyledText(iValueController.getEditPlaceholder(), 0);
        }
        this.editor.createPartControl(iValueController.getEditPlaceholder());
        StyledText styledText = this.editor.getEditorControl();
        assert (styledText != null);
        this.initEditorSettings(styledText);
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                JSONPanelEditor.this.editor.releaseEditorInput();
            }
        });
        return this.editor.getEditorControl();
    }

    public void primeEditorValue(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull StyledText styledText, @NotNull DBDContent dBDContent) throws DBException {
        dBRProgressMonitor.beginTask(ResultsetMessages.JSONPanelEditor_task_prime, 1);
        try {
            try {
                dBRProgressMonitor.subTask(ResultsetMessages.JSONPanelEditor_subtask_prime_task);
                ContentEditorInput contentEditorInput = new ContentEditorInput(this.valueController, null, null, dBRProgressMonitor);
                this.editor.init(this.subSite, (IEditorInput)contentEditorInput);
                this.applyEditorStyle();
            }
            catch (Exception exception) {
                throw new DBException(ResultsetMessages.JSONPanelEditor_e_load_xml, (Throwable)exception);
            }
        }
        finally {
            dBRProgressMonitor.done();
        }
    }

    public void extractEditorValue(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull StyledText styledText, @NotNull DBDContent dBDContent) throws DBException {
        if (this.valueController.isReadOnly() || !this.editor.isDirty()) {
            return;
        }
        dBRProgressMonitor.beginTask(ResultsetMessages.JSONPanelEditor_task_read_xml, 1);
        try {
            try {
                dBRProgressMonitor.subTask(ResultsetMessages.JSONPanelEditor_subtask_read_xml);
                this.editor.doSave(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)dBRProgressMonitor));
                ContentEditorInput contentEditorInput = (ContentEditorInput)this.editor.getEditorInput();
                contentEditorInput.updateContentFromFile(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)dBRProgressMonitor));
            }
            catch (Exception exception) {
                throw new DBException(ResultsetMessages.JSONPanelEditor_e_save_xml, (Throwable)exception);
            }
        }
        finally {
            dBRProgressMonitor.done();
        }
    }

    protected BaseTextEditor getTextEditor() {
        return this.editor;
    }
}

