/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.model;

import com.dbeaver.ent.cassandra.exec.CasSession;
import com.dbeaver.ent.cassandra.model.CasDataSource;
import com.dbeaver.ent.cassandra.model.CasKeyspace;
import com.dbeaver.ent.cassandra.model.CasTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class CasStructureAssistant
implements DBSStructureAssistant {
    private final CasDataSource dataSource;

    public CasStructureAssistant(CasDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor monitor, @Nullable DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        Throwable throwable = null;
        Object var10_11 = null;
        try (CasSession session = (CasSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Find Cassandra objects");){
            CasKeyspace keyspace = parentObject instanceof CasKeyspace ? (CasKeyspace)parentObject : null;
            this.findCollections(session, keyspace, objectNameMask, caseSensitive, references);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return references;
    }

    private void findCollections(CasSession session, CasKeyspace keyspace, String colNameMask, boolean caseSensitive, List<DBSObjectReference> objects) throws DBException {
        String likePattern = colNameMask.contains("%") ? colNameMask.replace("%", ".*") : Pattern.quote(colNameMask);
        Pattern pattern = Pattern.compile(likePattern, (caseSensitive ? 0 : 2) | 8);
        Collection<CasKeyspace> keyspaces = keyspace != null ? Collections.singleton(keyspace) : this.dataSource.getKeyspaces();
        DBRProgressMonitor monitor = session.getProgressMonitor();
        for (CasKeyspace ks : keyspaces) {
            for (CasTable table : ks.getTables(monitor)) {
                if (!pattern.matcher(table.getName()).matches()) continue;
                objects.add((DBSObjectReference)new CasTableReference(table));
            }
        }
    }

    private static class CasTableReference
    extends AbstractObjectReference {
        private final CasTable table;

        private CasTableReference(CasTable table) {
            super(table.getName(), (DBSObject)table.getKeyspace(), null, CasTable.class, RelationalObjectType.TYPE_TABLE);
            this.table = table;
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            return this.table;
        }
    }
}

