/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.model;

import com.datastax.driver.core.Host;
import com.dbeaver.ent.cassandra.model.CasDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasHost
implements DBSObject {
    private final CasDataSource dataSource;
    private final Host metadata;

    public CasHost(CasDataSource dataSource, Host metadata) {
        this.dataSource = dataSource;
        this.metadata = metadata;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getAddress().getHostAddress();
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getDescription() {
        return null;
    }

    @Property(viewable=true, expensive=true, order=2)
    public String getHostName(DBRProgressMonitor monitor) {
        return this.metadata.getAddress().getHostName();
    }

    @Property(viewable=true, order=3)
    public String getDatacenter() {
        return this.metadata.getDatacenter();
    }

    @Property(viewable=true, order=4)
    public String getRack() {
        return this.metadata.getRack();
    }

    @Property(viewable=true, order=5)
    public String getCassandraVersion() {
        return this.metadata.getCassandraVersion().toString();
    }
}

