/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.model;

import java.util.Date;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasCQLDialect
extends BasicSQLDialect {
    public static final CasCQLDialect INSTANCE = new CasCQLDialect();

    @NotNull
    public String getDialectName() {
        return "CQL";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.LOWER;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
    }

    public int getCatalogUsage() {
        return Integer.MAX_VALUE;
    }

    public boolean supportsSubqueries() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsNullability() {
        return false;
    }

    public String getColumnTypeModifiers(@NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (dataKind == DBPDataKind.STRING) {
            return null;
        }
        return super.getColumnTypeModifiers(column, typeName, dataKind);
    }

    @NotNull
    public String escapeScriptValue(DBSAttributeBase attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof UUID) {
            return strValue;
        }
        if (value instanceof Date) {
            return String.valueOf('\'') + strValue + '\'';
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }
}

