/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.data.AbstractContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CasContentBytes
extends AbstractContent
implements DBDValueCloneable,
DBDContentStorage,
DBDContentCached {
    private static final Log log = Log.getLog(CasContentBytes.class);
    private ByteBuffer originalData;
    private ByteBuffer data;

    public CasContentBytes(DBPDataSource dataSource) {
        super(dataSource);
        this.originalData = null;
        this.data = null;
    }

    public CasContentBytes(DBPDataSource dataSource, ByteBuffer data) {
        super(dataSource);
        this.data = this.originalData = data;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public InputStream getContentStream() throws IOException {
        if (this.data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.data.array(), this.data.position(), this.data.limit() - this.data.position());
    }

    public Reader getContentReader() throws IOException {
        return new InputStreamReader(this.getContentStream());
    }

    public long getContentLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.limit() - this.data.position();
    }

    public String getCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)this.dataSource);
    }

    public CasContentBytes cloneStorage(DBRProgressMonitor monitor) throws IOException {
        return this.cloneValue(monitor);
    }

    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        return this;
    }

    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) throws DBException {
        if (storage == null) {
            this.data = null;
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = storage.getContentStream();){
                    byte[] tmpBuf = new byte[(int)storage.getContentLength()];
                    int count = is.read(tmpBuf);
                    if (count != tmpBuf.length) {
                        log.warn((Object)("Actual content length (" + count + ") is less than declared (" + tmpBuf.length + ")"));
                    }
                    this.data = ByteBuffer.wrap(tmpBuf);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading content", (Throwable)e);
            }
        }
        this.modified = true;
        return false;
    }

    public void resetContents() {
        this.data = this.originalData;
        this.modified = false;
    }

    public Object getRawValue() {
        return this.data;
    }

    public boolean isNull() {
        return this.data == null;
    }

    public void release() {
        this.data = this.originalData;
    }

    public String getDisplayString(DBDDisplayFormat format) {
        int sourceLength;
        if (this.data == null) {
            return null;
        }
        DBDBinaryFormatter formatter = DBValueFormatting.getBinaryPresentation((DBPDataSource)this.dataSource);
        int maxLength = this.dataSource.getContainer().getPreferenceStore().getInt("resultset.binary.stringMaxLength");
        int length = sourceLength = this.data.limit() - this.data.position();
        if (format == DBDDisplayFormat.UI && length > maxLength) {
            length = maxLength;
        }
        String string = formatter.toString(this.data.array(), this.data.position(), sourceLength);
        if (length == sourceLength) {
            return string;
        }
        return String.valueOf(string) + "..." + " [" + sourceLength + "]";
    }

    public CasContentBytes cloneValue(DBRProgressMonitor monitor) {
        return new CasContentBytes(this.dataSource, this.data);
    }

    public Object getCachedValue() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CasContentBytes) {
            return CommonUtils.equalObjects((Object)this.data, (Object)((CasContentBytes)((Object)obj)).data);
        }
        return false;
    }

    public String toString() {
        return this.getDisplayString(DBDDisplayFormat.NATIVE);
    }
}

