/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.exec;

import com.dbeaver.ent.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ent.mongodb.exec.MongoSession;
import com.dbeaver.ent.mongodb.model.MGDatabase;
import com.mongodb.CommandResult;
import java.util.Collection;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.utils.CommonUtils;

public class MongoEvalStatement
extends MongoBaseStatement {
    public MongoEvalStatement(MongoSession session, String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            MGDatabase activeDatabase = this.session.getDataSource().getDefaultObject();
            if (activeDatabase == null) {
                throw new DBCException("No current database");
            }
            String js = this.getQueryString();
            js = js.replace('\n', ' ');
            CommandResult commandResult = activeDatabase.getDB().doEval(js, new Object[0]);
            if (!commandResult.ok()) {
                throw new DBCException("JavaScript error - " + commandResult.getErrorMessage());
            }
            this.setExecutionResult(commandResult);
            boolean bl = this.result != null || !CommonUtils.isEmpty((Collection)this.resultList);
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }
}

