/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.exec;

import com.dbeaver.ent.mongodb.MongoUtils;
import com.dbeaver.ent.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ent.mongodb.exec.MongoSession;
import com.dbeaver.ent.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MongoDeleteStatement
extends MongoBaseStatement {
    private DBSAttributeBase[] keyAttributes;
    private Object[] rowValues;

    public MongoDeleteStatement(MongoSession session, MGCollection mongoCollection, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, MongoDeleteStatement.makeQuery(mongoCollection, keyAttributes, rowValues));
        this.collection = mongoCollection;
        this.keyAttributes = keyAttributes;
        this.rowValues = rowValues;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            BasicDBObject q = new BasicDBObject();
            int i = 0;
            while (i < this.keyAttributes.length) {
                q.put(this.collection.getAttributeName(this.keyAttributes[i]), MongoUtils.unwrapMongoValue(this.keyAttributes[i], this.rowValues[i]));
                ++i;
            }
            this.writeResult = this.collection.getCollection().remove((DBObject)q);
            if (this.writeResult.getN() == 0) {
                throw new DBCException("Document wasn't deleted: " + this.writeResult);
            }
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (keyAttributes.length > 0) {
            sql.append(" WHERE ");
            int i = 0;
            while (i < keyAttributes.length) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(collection.getAttributeName(keyAttributes[i])).append("=").append(collection.getAttributeValue(keyAttributes[i], rowValues[i]));
                ++i;
            }
        }
        return sql.toString();
    }
}

