/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.data.handlers;

import com.dbeaver.ent.mongodb.data.handlers.MongoBooleanValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoContentValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoDocumentValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoIdValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoListValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoMapValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoNumberValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoStringValueHandler;
import com.dbeaver.ent.mongodb.data.handlers.MongoTimestampValueHandler;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDPreferences;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoValueHandlerProvider
implements DBDValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDPreferences preferences, DBSTypedObject typedObject) {
        switch (typedObject.getDataKind()) {
            case ROWID: {
                return MongoIdValueHandler.INSTANCE;
            }
            case STRUCT: {
                return MongoMapValueHandler.INSTANCE;
            }
            case BOOLEAN: {
                return MongoBooleanValueHandler.INSTANCE;
            }
            case NUMERIC: {
                return new MongoNumberValueHandler(typedObject, preferences.getDataFormatterProfile());
            }
            case STRING: {
                return MongoStringValueHandler.INSTANCE;
            }
            case BINARY: {
                return MongoContentValueHandler.INSTANCE;
            }
            case DATETIME: {
                return new MongoTimestampValueHandler(preferences.getDataFormatterProfile());
            }
            case ARRAY: {
                return MongoListValueHandler.INSTANCE;
            }
            case DOCUMENT: {
                return MongoDocumentValueHandler.INSTANCE;
            }
        }
        return MongoStringValueHandler.INSTANCE;
    }
}

