/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.data.handlers;

import com.dbeaver.ent.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.ent.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ent.mongodb.exec.MongoSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoNumberValueHandler
extends MongoBaseValueHandler {
    private static final Log log = Log.getLog(MongoNumberValueHandler.class);
    private DBDDataFormatter formatter;

    public MongoNumberValueHandler(DBSTypedObject type, DBDDataFormatterProfile formatterProfile) {
        try {
            this.formatter = formatterProfile.createFormatter("number", type);
        }
        catch (Exception e) {
            log.error((Object)"Can't create formatter for number value handler", (Throwable)e);
            this.formatter = DefaultDataFormatter.INSTANCE;
        }
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value == null) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)format);
        }
        if (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT) {
            if (value instanceof Number) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)value));
            }
            return value.toString();
        }
        return this.formatter.formatValue(value);
    }

    @NotNull
    public Class<Number> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Number.class;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object;
        }
        Class<Number> numberType = Number.class;
        return DBValueFormatting.convertStringToNumber((String)object.toString(), numberType, (DBDDataFormatter)this.formatter);
    }

    public Class<? extends Number> getNumberType(DBSTypedObject type) {
        return Number.class;
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
    }
}

