/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;

public class GenericSequence
implements DBSSequence,
DBPQualifiedObject {
    private GenericStructContainer container;
    private String name;
    private String description;
    private Number lastValue;
    private Number minValue;
    private Number maxValue;
    private Number incrementBy;

    public GenericSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy) {
        this.container = container;
        this.name = name;
        this.description = description;
        this.lastValue = lastValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.incrementBy = incrementBy;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.container.getDataSource();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.container.getCatalog(), this.container.getSchema(), this});
    }

    @Property(viewable=true, order=2)
    public Number getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Number lastValue) {
        this.lastValue = lastValue;
    }

    @Property(viewable=true, order=3)
    public Number getMinValue() {
        return this.minValue;
    }

    @Property(viewable=true, order=4)
    public Number getMaxValue() {
        return this.maxValue;
    }

    @Property(viewable=true, order=5)
    public Number getIncrementBy() {
        return this.incrementBy;
    }
}

