/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.handlers;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.data.office.export.DataExporterXLSX;
import org.jkiss.dbeaver.data.office.export.StreamPOIConsumerSettings;
import org.jkiss.dbeaver.data.office.export.StreamPOITransferConsumer;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCommandHandler;
import org.jkiss.utils.CommonUtils;

public class OpenSpreadsheetHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(OpenSpreadsheetHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetCommandHandler.getActiveResultSet((IWorkbenchPart)HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            DBeaverUI.getInstance().showError("Open Excel", "No active results viewer");
            return null;
        }
        final DBSDataContainer dataContainer = resultSet.getDataContainer();
        if (dataContainer == null || dataContainer.getDataSource() == null) {
            DBeaverUI.getInstance().showError("Open Excel", "Not connected to a database");
            return null;
        }
        AbstractJob exportJob = new AbstractJob("Open Excel"){
            {
                super($anonymous0);
                this.setUser(true);
                this.setSystem(false);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    File tempDir = DBeaverCore.getInstance().getTempFolder(monitor, "office-files");
                    final File tempFile = new File(tempDir, String.valueOf(CommonUtils.escapeFileName((String)CommonUtils.truncateString((String)dataContainer.getName(), (int)32))) + "." + new SimpleDateFormat("yyyyMMdd-HHmmss").format(System.currentTimeMillis()) + ".xlsx");
                    DataExporterXLSX exporter = new DataExporterXLSX();
                    StreamPOITransferConsumer consumer = new StreamPOITransferConsumer();
                    StreamPOIConsumerSettings settings = new StreamPOIConsumerSettings();
                    settings.setOutputEncodingBOM(false);
                    settings.setOpenFolderOnFinish(false);
                    settings.setOutputFolder(tempDir.getAbsolutePath());
                    settings.setOutputFilePattern(tempFile.getName());
                    Map<Object, Object> properties = DataExporterXLSX.getDefaultProperties();
                    consumer.initTransfer((DBSObject)dataContainer, settings, (IStreamDataExporter)exporter, properties);
                    DatabaseTransferProducer producer = new DatabaseTransferProducer(dataContainer);
                    DatabaseProducerSettings producerSettings = new DatabaseProducerSettings();
                    producerSettings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    producerSettings.setQueryRowCount(false);
                    producer.transferData(monitor, (IDataTransferConsumer)consumer, producerSettings);
                    consumer.finishTransfer(monitor, false);
                    DBeaverUI.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!UIUtils.launchProgram((String)tempFile.getAbsolutePath())) {
                                DBeaverUI.getInstance().showError("Open XLSX", "Can't open XLSX file '" + tempFile.getAbsolutePath() + "'");
                            }
                        }
                    });
                }
                catch (Exception e) {
                    DBeaverUI.getInstance().showError("Error opening in Excel", null, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        exportJob.schedule();
        return null;
    }
}

