/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.export;

import java.util.Collection;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.registry.transfer.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerPageSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class StreamPOIConsumerPageSettings
extends StreamConsumerPageSettings {
    private PropertyTreeViewer propsEditor;
    private Combo formatProfilesCombo;
    private PropertySourceCustom propertySource;

    public StreamPOIConsumerPageSettings() {
        this.setTitle(CoreMessages.data_transfer_wizard_settings_title);
        this.setDescription(CoreMessages.data_transfer_wizard_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        final StreamConsumerSettings settings = (StreamConsumerSettings)((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Group generalSettings = new Group(composite, 0);
        generalSettings.setText(CoreMessages.data_transfer_wizard_settings_group_general);
        gl = new GridLayout(4, false);
        generalSettings.setLayout((Layout)gl);
        generalSettings.setLayoutData((Object)new GridData(768));
        Composite formattingGroup = UIUtils.createPlaceholder((Composite)generalSettings, (int)3);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        formattingGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)formattingGroup, (String)CoreMessages.data_transfer_wizard_settings_label_formatting);
        this.formatProfilesCombo = new Combo(formattingGroup, 12);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.formatProfilesCombo.setLayoutData((Object)gd);
        this.formatProfilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StreamPOIConsumerPageSettings.this.formatProfilesCombo.getSelectionIndex() > 0) {
                    settings.setFormatterProfile(DataFormatterRegistry.getInstance().getCustomProfile(UIUtils.getComboSelection((Combo)StreamPOIConsumerPageSettings.this.formatProfilesCombo)));
                } else {
                    settings.setFormatterProfile(null);
                }
            }
        });
        Button profilesManageButton = new Button(formattingGroup, 8);
        profilesManageButton.setText(CoreMessages.data_transfer_wizard_settings_button_edit);
        profilesManageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog propDialog = PreferencesUtil.createPropertyDialogOn((Shell)StreamPOIConsumerPageSettings.this.getShell(), (Object)DataFormatterRegistry.getInstance(), (String)"org.jkiss.dbeaver.preferences.main.dataformat", null, (Object)StreamPOIConsumerPageSettings.this.getSelectedFormatterProfile(), (int)0);
                if (propDialog != null) {
                    propDialog.open();
                    StreamPOIConsumerPageSettings.this.reloadFormatProfiles();
                }
            }
        });
        this.reloadFormatProfiles();
        Group exporterSettings = new Group(composite, 0);
        exporterSettings.setText(CoreMessages.data_transfer_wizard_settings_group_exporter);
        exporterSettings.setLayoutData((Object)new GridData(1808));
        exporterSettings.setLayout((Layout)new GridLayout(1, false));
        this.propsEditor = new PropertyTreeViewer((Composite)exporterSettings, 2048);
        this.setControl((Control)composite);
    }

    private Object getSelectedFormatterProfile() {
        DataFormatterRegistry registry = DataFormatterRegistry.getInstance();
        int selectionIndex = this.formatProfilesCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        if (selectionIndex == 0) {
            return registry.getGlobalProfile();
        }
        return registry.getCustomProfile(UIUtils.getComboSelection((Combo)this.formatProfilesCombo));
    }

    private void reloadFormatProfiles() {
        DataFormatterRegistry registry = DataFormatterRegistry.getInstance();
        this.formatProfilesCombo.removeAll();
        this.formatProfilesCombo.add(CoreMessages.data_transfer_wizard_settings_listbox_formatting_item_default);
        for (DBDDataFormatterProfile profile : registry.getCustomProfiles()) {
            this.formatProfilesCombo.add(profile.getProfileName());
        }
        StreamConsumerSettings settings = (StreamConsumerSettings)((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        DBDDataFormatterProfile formatterProfile = settings.getFormatterProfile();
        if (formatterProfile != null) {
            if (!UIUtils.setComboSelection((Combo)this.formatProfilesCombo, (String)formatterProfile.getProfileName())) {
                this.formatProfilesCombo.select(0);
            }
        } else {
            this.formatProfilesCombo.select(0);
        }
    }

    public void activatePage() {
        StreamConsumerSettings settings = (StreamConsumerSettings)((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        this.propertySource = new PropertySourceCustom((Collection)processor.getProperties(), ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        ((DataTransferWizard)this.getWizard()).getSettings().setProcessorProperties(this.propertySource.getPropertiesWithDefaults());
    }

    protected boolean determinePageCompletion() {
        return true;
    }
}

