/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.utils.CommonUtils;

public class DBVTransformSettings {
    private Set<String> excludedTransformers;
    private Set<String> includedTransformers;
    private String customTransformer;
    private Map<String, String> transformOptions;

    public Set<String> getExcludedTransformers() {
        return this.excludedTransformers;
    }

    public boolean isExcluded(String id) {
        return this.excludedTransformers != null && this.excludedTransformers.contains(id);
    }

    public Set<String> getIncludedTransformers() {
        return this.includedTransformers;
    }

    public boolean isIncluded(String id) {
        return this.includedTransformers != null && this.includedTransformers.contains(id);
    }

    public void enableTransformer(DBDAttributeTransformerDescriptor transformer, boolean enable) {
        String id = transformer.getId();
        if (this.includedTransformers == null) {
            this.includedTransformers = new HashSet<String>();
        }
        if (this.excludedTransformers == null) {
            this.excludedTransformers = new HashSet<String>();
        }
        if (enable) {
            if (!transformer.isApplicableByDefault()) {
                this.includedTransformers.add(id);
            }
            this.excludedTransformers.remove(id);
        } else {
            if (transformer.isApplicableByDefault()) {
                this.excludedTransformers.add(id);
            }
            this.includedTransformers.remove(id);
        }
    }

    public String getCustomTransformer() {
        return this.customTransformer;
    }

    public void setCustomTransformer(String customTransformer) {
        this.customTransformer = customTransformer;
    }

    public Map<String, String> getTransformOptions() {
        return this.transformOptions;
    }

    public void setTransformOption(String name, String value) {
        if (this.transformOptions == null) {
            this.transformOptions = new LinkedHashMap<String, String>();
        }
        this.transformOptions.put(name, value);
    }

    public void setTransformOptions(Map<String, String> transformOptions) {
        this.transformOptions = transformOptions;
    }

    public boolean hasValuableData() {
        return !CommonUtils.isEmpty(this.excludedTransformers) || !CommonUtils.isEmpty(this.includedTransformers) || !CommonUtils.isEmpty((String)this.customTransformer);
    }

    public boolean filterTransformers(List<? extends DBDAttributeTransformerDescriptor> descriptors) {
        if (!this.hasValuableData()) {
            return false;
        }
        int i = 0;
        while (i < descriptors.size()) {
            boolean valid;
            DBDAttributeTransformerDescriptor descriptor = descriptors.get(i);
            if (descriptor.isCustom()) {
                valid = descriptor.getId().equals(this.customTransformer);
            } else if (descriptor.isApplicableByDefault()) {
                valid = this.excludedTransformers == null || !this.excludedTransformers.contains(descriptor.getId());
            } else {
                boolean bl = valid = this.includedTransformers != null && this.includedTransformers.contains(descriptor.getId());
            }
            if (!valid) {
                descriptors.remove(i);
                continue;
            }
            ++i;
        }
        return true;
    }
}

