/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime.load;

import java.lang.reflect.InvocationTargetException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.BlockCanceler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;

public abstract class AbstractLoadService<RESULT>
implements ILoadService<RESULT> {
    private String serviceName;
    private DBRProgressMonitor progressMonitor;
    private AbstractJob ownerJob;

    protected AbstractLoadService(String serviceName) {
        this.serviceName = serviceName;
    }

    protected AbstractLoadService() {
        this("Loading");
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void initService(DBRProgressMonitor monitor, AbstractJob ownerJob) {
        this.progressMonitor = monitor;
        this.ownerJob = ownerJob;
    }

    @Override
    public boolean cancel() throws InvocationTargetException {
        if (this.ownerJob != null) {
            return this.ownerJob.cancel();
        }
        if (this.progressMonitor != null) {
            try {
                BlockCanceler.cancelBlock(this.progressMonitor, null);
                return true;
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
        return false;
    }
}

