/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class BlockCanceler
extends Job {
    private static final long INTERRUPT_TIMEOUT = 2000L;
    private final Thread thread;
    private boolean blockCanceled = false;

    public BlockCanceler(Thread thread) {
        super("Interrupter of " + thread.getName());
        this.setSystem(true);
        this.setUser(false);
        this.thread = thread;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.blockCanceled) {
            this.thread.interrupt();
        }
        return Status.OK_STATUS;
    }

    public static void cancelBlock(DBRProgressMonitor monitor, Thread blockActiveThread) throws DBException {
        DBRBlockingObject block;
        BlockCanceler canceler = null;
        if (blockActiveThread != null) {
            canceler = new BlockCanceler(blockActiveThread);
            canceler.schedule(2000L);
        }
        if ((block = monitor.getActiveBlock()) != null) {
            Thread thread = Thread.currentThread();
            String threadOldName = thread.getName();
            thread.setName("Operation cancel [" + block + "]");
            try {
                try {
                    block.cancelBlock();
                    if (canceler != null) {
                        canceler.blockCanceled = true;
                    }
                }
                catch (Throwable e) {
                    throw new DBException("Cancel error", e);
                }
            }
            finally {
                thread.setName(threadOldName);
            }
        }
    }
}

