/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeIcon;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.utils.CommonUtils;

public abstract class DBXTreeNode {
    private static final Log log = Log.getLog(DBXTreeNode.class);
    private final AbstractDescriptor source;
    private final DBXTreeNode parent;
    private final String id;
    private List<DBXTreeNode> children;
    private DBPImage defaultIcon;
    private List<DBXTreeIcon> icons;
    private final boolean navigable;
    private final boolean inline;
    private final boolean virtual;
    private boolean standaloneNode;
    private Expression visibleIf;
    private DBXTreeNode recursiveLink;
    private List<DBXTreeNodeHandler> handlers = null;

    public DBXTreeNode(AbstractDescriptor source, DBXTreeNode parent, String id, boolean navigable, boolean inline, boolean virtual, boolean standalone, String visibleIf, String recursive) {
        this.source = source;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.id = id;
        this.navigable = navigable;
        this.inline = inline;
        this.virtual = virtual;
        this.standaloneNode = standalone;
        if (!CommonUtils.isEmpty((String)visibleIf)) {
            try {
                this.visibleIf = AbstractDescriptor.parseExpression(visibleIf);
            }
            catch (DBException e) {
                log.warn(e);
            }
        }
        if (recursive != null) {
            this.recursiveLink = this;
            String[] stringArray = recursive.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.equals("..")) {
                    this.recursiveLink = this.recursiveLink.parent;
                }
                ++n2;
            }
        }
    }

    public DBXTreeNode(AbstractDescriptor source, DBXTreeNode parent, DBXTreeNode node) {
        this.source = source;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.id = node.id;
        this.navigable = node.navigable;
        this.inline = node.inline;
        this.virtual = node.virtual;
        this.standaloneNode = node.standaloneNode;
        this.visibleIf = node.visibleIf;
        DBXTreeNode cfr_ignored_0 = node.recursiveLink;
        this.defaultIcon = node.defaultIcon;
        if (node.icons != null) {
            this.icons = new ArrayList<DBXTreeIcon>(node.icons);
        }
        if (node.children != null) {
            this.children = new ArrayList<DBXTreeNode>(node.children.size());
            for (DBXTreeNode child : node.children) {
                if (child instanceof DBXTreeObject) {
                    new DBXTreeObject(source, this, (DBXTreeObject)child);
                    continue;
                }
                if (child instanceof DBXTreeFolder) {
                    new DBXTreeFolder(source, this, (DBXTreeFolder)child);
                    continue;
                }
                new DBXTreeItem(source, this, (DBXTreeItem)child);
            }
        }
        if (node.handlers != null) {
            this.handlers = new ArrayList<DBXTreeNodeHandler>(node.handlers);
        }
    }

    public AbstractDescriptor getSource() {
        return this.source;
    }

    public abstract String getNodeType(DBPDataSource var1);

    public abstract String getChildrenType(DBPDataSource var1);

    public boolean isNavigable() {
        return this.navigable;
    }

    public boolean isInline() {
        return this.inline;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isStandaloneNode() {
        return this.standaloneNode;
    }

    public DBXTreeNode getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasChildren(DBNNode context) {
        return this.hasChildren(context, false);
    }

    public boolean hasChildren(DBNNode context, boolean navigable) {
        if (CommonUtils.isEmpty(this.children)) {
            return this.recursiveLink != null && this.recursiveLink.hasChildren(context, navigable);
        }
        if (context == null) {
            return true;
        }
        for (DBXTreeNode child : this.children) {
            if (navigable && !child.isNavigable() || !child.isVisible(context)) continue;
            return true;
        }
        return false;
    }

    protected List<DBXTreeNode> getChildren() {
        return this.children;
    }

    public List<DBXTreeNode> getChildren(DBNNode context) {
        if (context != null && !CommonUtils.isEmpty(this.children)) {
            boolean hasExpr = false;
            for (DBXTreeNode child : this.children) {
                if (child.getVisibleIf() == null) continue;
                hasExpr = true;
                break;
            }
            if (hasExpr) {
                ArrayList<DBXTreeNode> filteredChildren = new ArrayList<DBXTreeNode>(this.children.size());
                for (DBXTreeNode child : this.children) {
                    if (!child.isVisible(context)) continue;
                    filteredChildren.add(child);
                }
                return filteredChildren;
            }
        }
        if (this.children == null) {
            if (this.recursiveLink != null) {
                return this.recursiveLink.getChildren(context);
            }
            return Collections.emptyList();
        }
        return this.children;
    }

    private boolean isVisible(DBNNode context) {
        try {
            return this.visibleIf == null || Boolean.TRUE.equals(this.visibleIf.evaluate(DBXTreeNode.makeContext(context)));
        }
        catch (JexlException e) {
            log.warn((Object)e);
            return false;
        }
    }

    public void addChild(DBXTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<DBXTreeNode>();
        }
        this.children.add(child);
    }

    public DBXTreeNode getRecursiveLink() {
        return this.recursiveLink;
    }

    public DBPImage getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(DBPImage defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public List<DBXTreeIcon> getIcons() {
        return this.icons;
    }

    public void addIcon(DBXTreeIcon icon) {
        if (this.icons == null) {
            this.icons = new ArrayList<DBXTreeIcon>();
        }
        this.icons.add(icon);
    }

    public DBPImage getIcon(DBNNode context) {
        List<DBXTreeIcon> extIcons = this.getIcons();
        if (!CommonUtils.isEmpty(extIcons)) {
            for (DBXTreeIcon icon : extIcons) {
                if (icon.getExpression() == null) continue;
                try {
                    Object result = icon.getExpression().evaluate(DBXTreeNode.makeContext(context));
                    if (!Boolean.TRUE.equals(result)) continue;
                    return icon.getIcon();
                }
                catch (JexlException e) {
                    log.debug("Error evaluating expression '" + icon.getExprString() + "'", e);
                }
            }
        }
        return this.getDefaultIcon();
    }

    public Expression getVisibleIf() {
        return this.visibleIf;
    }

    public String toString() {
        return "Node " + this.id;
    }

    public void addActionHandler(DBXTreeNodeHandler.Action action, DBXTreeNodeHandler.Perform perform, String command) {
        if (this.handlers == null) {
            this.handlers = new ArrayList<DBXTreeNodeHandler>();
        }
        this.handlers.add(new DBXTreeNodeHandler(action, perform, command));
    }

    public DBXTreeNodeHandler getHandler(DBXTreeNodeHandler.Action action) {
        if (this.handlers != null) {
            for (DBXTreeNodeHandler handler : this.handlers) {
                if (handler.getAction() != action) continue;
                return handler;
            }
        }
        return null;
    }

    private static JexlContext makeContext(final DBNNode node) {
        return new JexlContext(){

            public Object get(String name) {
                if (node instanceof DBNDatabaseNode && name.equals("object")) {
                    return ((DBNDatabaseNode)node).getValueObject();
                }
                return null;
            }

            public void set(String name, Object value) {
                log.warn("Set is not implemented in DBX model");
            }

            public boolean has(String name) {
                return node instanceof DBNDatabaseNode && name.equals("object") && ((DBNDatabaseNode)node).getValueObject() != null;
            }
        };
    }
}

