/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNResource
extends DBNNode {
    private static final Log log = Log.getLog(DBNResource.class);
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private IResource resource;
    private DBPResourceHandler handler;
    private DBNNode[] children;
    private DBPImage resourceImage;

    public DBNResource(DBNNode parentNode, IResource resource, DBPResourceHandler handler) {
        super(parentNode);
        this.resource = resource;
        this.handler = handler;
    }

    @Override
    protected void dispose(boolean reflect) {
        if (this.handler != null) {
            if (this.children != null) {
                DBNNode[] dBNNodeArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNNode child = dBNNodeArray[n2];
                    child.dispose(reflect);
                    ++n2;
                }
                this.children = null;
            }
            if (reflect) {
                this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, this));
            }
            this.resource = null;
            this.handler = null;
        }
        super.dispose(reflect);
    }

    public int getFeatures() {
        return this.handler == null ? 0 : this.handler.getFeatures(this.resource);
    }

    @Override
    public String getNodeType() {
        return this.handler == null ? null : this.handler.getTypeName(this.resource);
    }

    @Override
    @Property(viewable=true, order=1)
    public String getNodeName() {
        if (this.resource == null || this.handler == null) {
            return null;
        }
        return this.handler.getResourceNodeName(this.resource);
    }

    @Override
    public String getNodeDescription() {
        return this.handler == null || this.resource == null ? null : this.handler.getResourceDescription(this.resource);
    }

    @Override
    public DBPImage getNodeIcon() {
        if (this.resourceImage != null) {
            return this.resourceImage;
        }
        if (this.resource == null) {
            return null;
        }
        switch (this.resource.getType()) {
            case 2: {
                return this.resource.isLinked() ? DBIcon.TREE_FOLDER_LINK : DBIcon.TREE_FOLDER;
            }
            case 4: {
                return DBIcon.PROJECT;
            }
        }
        return DBIcon.TREE_PAGE;
    }

    @Override
    public boolean allowsChildren() {
        return this.resource instanceof IContainer;
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && this.resource instanceof IContainer) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBNNode> result = new ArrayList<DBNNode>();
        try {
            if (this.resource.exists()) {
                IResource[] members = ((IContainer)this.resource).members(false);
                IResource[] iResourceArray = members = this.addImplicitMembers(members);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    DBNNode newChild = this.makeNode(member);
                    if (newChild != null) {
                        result.add(newChild);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't read container's members", e);
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        this.filterChildren(result);
        DBNNode[] childNodes = result.toArray(new DBNNode[result.size()]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    protected IResource[] addImplicitMembers(IResource[] members) {
        return members;
    }

    DBNResource getChild(IResource resource) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNResource && resource.equals((Object)((DBNResource)child).getResource())) {
                return (DBNResource)child;
            }
            ++n2;
        }
        return null;
    }

    private DBNNode makeNode(IResource resource) {
        DBPResourceHandler resourceHandler;
        block5: {
            if (resource.getParent() instanceof IProject && resource.getName().startsWith(".")) {
                return null;
            }
            try {
                if (resource instanceof IFolder && resource.getParent() instanceof IFolder) {
                    return this.handler.makeNavigatorNode(this, resource);
                }
                resourceHandler = this.getModel().getPlatform().getProjectManager().getResourceHandler(resource);
                if (resourceHandler != null) break block5;
                log.debug("Skip resource '" + resource.getName() + "'");
                return null;
            }
            catch (Exception e) {
                log.error("Error creating navigator node for resource '" + resource.getName() + "'", e);
                return null;
            }
        }
        return resourceHandler.makeNavigatorNode(this, resource);
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        try {
            this.resource.refreshLocal(2, monitor.getNestedMonitor());
            if (!this.resource.getLocation().toFile().exists()) {
                log.warn("Resource '" + this.resource.getName() + "' doesn't exists on file system: deleted in workspace");
                this.resource.delete(true, monitor.getNestedMonitor());
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't refresh resource", e);
        }
        return this;
    }

    @Override
    public String getNodeItemPath() {
        StringBuilder pathName = new StringBuilder();
        DBNNode node = this;
        while (node instanceof DBNResource) {
            if (pathName.length() > 0) {
                pathName.insert(0, '/');
            }
            pathName.insert(0, node.getResource().getName());
            node = node.getParentNode();
        }
        return String.valueOf(DBNNode.NodePathType.resource.getPrefix()) + pathName.toString();
    }

    @Override
    public boolean supportsRename() {
        return (this.getFeatures() & 8) != 0;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        try {
            String ext;
            if (newName.indexOf(46) == -1 && this.resource instanceof IFile && !CommonUtils.isEmpty((String)(ext = this.resource.getFileExtension()))) {
                newName = String.valueOf(newName) + "." + ext;
            }
            if (!newName.equals(this.resource.getName())) {
                this.resource.move(this.resource.getParent().getFullPath().append(newName), true, monitor.getNestedMonitor());
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't rename resource", e);
        }
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        if (!(this.resource instanceof IFolder) || (this.getFeatures() & 0x10) == 0) {
            return false;
        }
        if (otherNode == null) {
            return true;
        }
        return otherNode instanceof DBNResource && otherNode != this && otherNode.getParentNode() != this && !this.isChildOf(otherNode) && ((DBNResource)otherNode).handler == this.handler;
    }

    @Override
    public void dropNodes(Collection<DBNNode> nodes) throws DBException {
        for (DBNNode node : nodes) {
            DBNResource resourceNode = (DBNResource)node;
            IResource otherResource = resourceNode.getResource();
            if (otherResource == null) continue;
            try {
                otherResource.move(this.resource.getFullPath().append(otherResource.getName()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new DBException("Can't delete resource", e);
            }
        }
    }

    @Nullable
    public IResource getResource() {
        return this.resource;
    }

    protected void filterChildren(List<DBNNode> list) {
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, new Comparator<DBNNode>(){

            @Override
            public int compare(DBNNode o1, DBNNode o2) {
                if (o1 instanceof DBNProjectDatabases) {
                    return -1;
                }
                if (o2 instanceof DBNProjectDatabases) {
                    return 1;
                }
                if (o1 instanceof DBNResource && o2 instanceof DBNResource) {
                    IResource res1 = ((DBNResource)o1).getResource();
                    IResource res2 = ((DBNResource)o2).getResource();
                    if (res1 instanceof IFolder && !(res2 instanceof IFolder)) {
                        return -1;
                    }
                    if (res2 instanceof IFolder && !(res1 instanceof IFolder)) {
                        return 1;
                    }
                }
                return o1.getNodeName().compareToIgnoreCase(o2.getNodeName());
            }
        });
    }

    public void setResourceImage(DBPImage resourceImage) {
        this.resourceImage = resourceImage;
    }

    public void createNewFolder(String folderName) throws DBException {
        if (this.resource instanceof IFolder) {
            try {
                IFolder newFolder;
                IFolder parentFolder = (IFolder)this.resource;
                if (!parentFolder.exists()) {
                    parentFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((newFolder = parentFolder.getFolder(folderName)).exists()) {
                    throw new DBException("Folder '" + folderName + "' already exists in '" + this.resource.getFullPath().toString() + "'");
                }
                newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new DBException("Can't create new folder", e);
            }
        }
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return this.handler == null ? null : this.handler.getAssociatedDataSources(this.resource);
    }

    public void refreshResourceState(Object source) {
        DBPResourceHandler newHandler = this.getModel().getPlatform().getProjectManager().getResourceHandler(this.resource);
        if (newHandler != this.handler) {
            this.handler = newHandler;
        }
        this.handler.updateNavigatorNode(this, this.resource);
        this.getModel().fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    protected void handleResourceChange(IResourceDelta delta) {
        if (delta.getKind() == 4) {
            this.refreshResourceState(delta);
        }
        if (this.children == null) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(31, 8);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            this.handleChildResourceChange(childDelta);
            ++n2;
        }
    }

    protected void handleChildResourceChange(IResourceDelta delta) {
        IResource deltaResource = delta.getResource();
        DBNResource childResource = this.getChild(deltaResource);
        if (childResource == null) {
            DBNNode newChild;
            if ((delta.getKind() == 1 || delta.getKind() == 4) && (newChild = this.makeNode(deltaResource)) != null) {
                this.children = (DBNNode[])ArrayUtils.add(DBNNode.class, (Object[])this.children, (Object)newChild);
                this.sortChildren(this.children);
                this.getModel().fireNodeEvent(new DBNEvent(delta, DBNEvent.Action.ADD, newChild));
                if (delta.getKind() == 4 && (childResource = this.getChild(deltaResource)) != null) {
                    childResource.handleResourceChange(delta);
                }
            }
        } else if (delta.getKind() == 2) {
            this.children = (DBNNode[])ArrayUtils.remove(DBNNode.class, (Object[])this.children, (Object)childResource);
            childResource.dispose(true);
        } else {
            childResource.handleResourceChange(delta);
        }
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.resource == null ? "" : this.resource.getFullPath().toOSString();
    }

    @Property(viewable=false, order=11)
    public String getResourceLocation() {
        return this.resource == null ? "" : this.resource.getLocation().toOSString();
    }

    @Property(viewable=true, order=11)
    public long getResourceSize() {
        return this.resource == null ? 0L : this.resource.getLocation().toFile().length();
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() {
        return this.resource == null ? null : DATE_FORMAT.format(this.resource.getLocation().toFile().lastModified());
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.resource != null && adapter.isAssignableFrom(this.resource.getClass())) {
            return adapter.cast(this.resource);
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.resource == null ? super.toString() : this.resource.toString();
    }
}

