/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCDataType<OWNER extends DBSObject>
implements DBSDataType {
    private final OWNER owner;
    private int valueType;
    private String name;
    private String remarks;
    private boolean isUnsigned;
    private boolean isSearchable;
    private int precision;
    private int minScale;
    private int maxScale;

    public JDBCDataType(OWNER owner, int valueType, String name, @Nullable String remarks, boolean unsigned, boolean searchable, int precision, int minScale, int maxScale) {
        this.owner = owner;
        this.valueType = valueType;
        this.name = name;
        this.remarks = remarks;
        this.isUnsigned = unsigned;
        this.isSearchable = searchable;
        this.precision = precision;
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    public JDBCDataType(OWNER owner, DBSTypedObject typed) {
        this(owner, typed.getTypeID(), typed.getTypeName(), null, false, false, typed.getPrecision(), typed.getScale(), typed.getScale());
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    @Override
    public String getFullTypeName() {
        return DBUtils.getFullTypeName(this);
    }

    @Override
    public int getTypeID() {
        return this.valueType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @NotNull
    public OWNER getParentObject() {
        return this.owner;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    @Override
    public DBPDataKind getDataKind() {
        return JDBCUtils.resolveDataKind(this.getDataSource(), this.name, this.valueType);
    }

    @Override
    public Integer getScale() {
        return this.minScale;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public long getMaxLength() {
        return this.precision;
    }

    @Override
    @Nullable
    public Object geTypeExtension() {
        return null;
    }

    @Override
    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public int getMinScale() {
        return this.minScale;
    }

    @Override
    public int getMaxScale() {
        return this.maxScale;
    }

    @Override
    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators(attribute);
    }

    public String toString() {
        return String.valueOf(this.owner.getName()) + "." + this.name;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }
}

