/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookup;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class JDBCStructLookupCache<OWNER extends DBSObject, OBJECT extends DBSObject, CHILD extends DBSObject>
extends JDBCStructCache<OWNER, OBJECT, CHILD>
implements JDBCObjectLookup<OWNER, OBJECT> {
    private final Set<String> missingNames = new HashSet<String>();

    public JDBCStructLookupCache(Object objectNameColumn) {
        super(objectNameColumn);
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        Object cachedObject = this.getCachedObject(name);
        if (cachedObject != null) {
            return cachedObject;
        }
        if (this.isFullyCached() || this.missingNames.contains(name)) {
            return null;
        }
        OBJECT object = this.reloadObject(monitor, owner, null, name);
        if (object != null) {
            this.cacheObject(object);
        } else {
            this.missingNames.add(name);
        }
        return object;
    }

    public OBJECT refreshObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull OBJECT oldObject) throws DBException {
        String objectName = oldObject.getName();
        if (this.isFullyCached()) {
            OBJECT newObject = this.reloadObject(monitor, owner, oldObject, null);
            if (this.isChildrenCached(oldObject)) {
                this.clearChildrenCache(oldObject);
            }
            if (newObject != null) {
                this.deepCopyCachedObject(newObject, oldObject);
            } else {
                this.removeObject(oldObject, false);
            }
            return oldObject;
        }
        this.loadObjects(monitor, owner);
        return this.getCachedObject(objectName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OBJECT reloadObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @Nullable OBJECT object, @Nullable String objectName) throws DBException {
        DBPDataSource dataSource = owner.getDataSource();
        if (dataSource == null) {
            throw new DBException("Not connected to database");
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession(monitor, dataSource, object == null ? "Load object '" + objectName + "' from " + owner.getName() : "Reload object '" + object + "' from " + owner.getName());
                try {
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try {
                        Object OBJECT;
                        JDBCStatement dbStat;
                        block20: {
                            dbStat = this.prepareLookupStatement(session, owner, object, objectName);
                            dbStat.setFetchSize(1);
                            dbStat.executeStatement();
                            JDBCResultSet dbResult = dbStat.getResultSet();
                            if (dbResult != null) {
                                try {
                                    if (!dbResult.next()) break block20;
                                    OBJECT = this.fetchObject(session, owner, dbResult);
                                    break block21;
                                }
                                finally {
                                    dbResult.close();
                                }
                            }
                        }
                        if (session == null) return null;
                        session.close();
                        return null;
                        {
                            block21: {
                                finally {
                                    if (dbStat == null) break block21;
                                    dbStat.close();
                                }
                            }
                            if (session == null) return OBJECT;
                            session.close();
                            return OBJECT;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (session == null) throw throwable4;
                    session.close();
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException("Error loading object metadata from database", ex, dataSource);
        }
    }

    @Override
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OWNER owner) throws SQLException {
        return this.prepareLookupStatement(session, owner, null, null);
    }

    @Override
    public void setCache(List<OBJECT> objects) {
        super.setCache(objects);
        this.missingNames.clear();
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.missingNames.clear();
    }
}

