/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.utils.CommonUtils;

public class DefaultServerOutputReader
implements DBCServerOutputReader {
    private final SQLQueryResult queryResult;

    public DefaultServerOutputReader(SQLQueryResult queryResult) {
        this.queryResult = queryResult;
    }

    @Override
    public boolean isServerOutputEnabled() {
        return true;
    }

    @Override
    public void enableServerOutput(DBRProgressMonitor monitor, DBCExecutionContext context, boolean enable) throws DBCException {
    }

    @Override
    public void readServerOutput(DBRProgressMonitor monitor, DBCExecutionContext context, PrintWriter output) throws DBCException {
        List<Throwable> warnings = this.queryResult.getWarnings();
        if (warnings != null && warnings.size() > 0) {
            for (Throwable warning : warnings) {
                String sqlState;
                if (warning instanceof SQLException && !CommonUtils.isEmpty((String)(sqlState = ((SQLException)warning).getSQLState()))) {
                    output.print(String.valueOf(sqlState) + ": ");
                }
                output.println(warning.getMessage());
            }
        }
    }
}

