/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class AbstractSession
implements DBCSession,
DBRBlockingObject {
    private DBRProgressMonitor monitor;
    private DBCExecutionPurpose purpose;
    private String taskTitle;
    private DBDDataFormatterProfile dataFormatterProfile;
    private boolean holdsBlock = false;
    private boolean loggingEnabled = true;

    public AbstractSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle) {
        this.monitor = monitor;
        this.purpose = purpose;
        this.taskTitle = taskTitle;
        if (taskTitle != null) {
            monitor.startBlock(this, taskTitle);
            this.holdsBlock = true;
        }
        QMUtils.getDefaultHandler().handleSessionOpen(this);
    }

    @Override
    @NotNull
    public String getTaskTitle() {
        return this.taskTitle;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    @NotNull
    public DBRProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    @NotNull
    public DBCExecutionPurpose getPurpose() {
        return this.purpose;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void enableLogging(boolean enable) {
        this.loggingEnabled = enable;
    }

    @Override
    public DBDDataFormatterProfile getDataFormatterProfile() {
        if (this.dataFormatterProfile == null) {
            return this.getDataSource().getContainer().getDataFormatterProfile();
        }
        return this.dataFormatterProfile;
    }

    @Override
    public void setDataFormatterProfile(DBDDataFormatterProfile formatterProfile) {
        this.dataFormatterProfile = formatterProfile;
    }

    @Override
    @NotNull
    public DBDValueHandler getDefaultValueHandler() {
        return DefaultValueHandler.INSTANCE;
    }

    @Override
    public void close() {
        if (this.holdsBlock) {
            this.monitor.endBlock();
            this.holdsBlock = false;
        }
        QMUtils.getDefaultHandler().handleSessionClose(this);
    }
}

