/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.utils.CommonUtils;

public class DBExecUtils {
    private static final ThreadLocal<DBCExecutionContext> ACTIVE_CONTEXT = new ThreadLocal();
    private static final List<DBCExecutionContext> ACTIVE_CONTEXTS = new ArrayList<DBCExecutionContext>();

    public static DBCExecutionContext getCurrentThreadContext() {
        return ACTIVE_CONTEXT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBCExecutionContext> getActiveContexts() {
        List<DBCExecutionContext> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            return new ArrayList<DBCExecutionContext>(ACTIVE_CONTEXTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startContextInitiation(DBCExecutionContext context) {
        ACTIVE_CONTEXT.set(context);
        List<DBCExecutionContext> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishContextInitiation(DBCExecutionContext context) {
        ACTIVE_CONTEXT.remove();
        List<DBCExecutionContext> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBCExecutionContext findConnectionContext(String host, int port, String path) {
        DBCExecutionContext curContext = DBExecUtils.getCurrentThreadContext();
        if (curContext != null) {
            return curContext;
        }
        List<DBCExecutionContext> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            for (DBCExecutionContext ctx : ACTIVE_CONTEXTS) {
                DBPConnectionConfiguration cfg = ctx.getDataSource().getContainer().getConnectionConfiguration();
                if (!CommonUtils.equalObjects((Object)cfg.getHostName(), (Object)host) || !String.valueOf(port).equals(cfg.getHostPort())) continue;
                return ctx;
            }
        }
        return null;
    }
}

